/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class DominoIIOPMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DominoIIOPMonitor.class);
    private static final int DEFAULT_PORT = 63148;
    private static final int DEFAULT_IORPORT = 80;
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 3, 3000);
        int IORport = ParameterMap.getKeyedInteger(parameters, (String)"ior-port", (int)80);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)63148);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipv4Addr);
        LOG.debug("poll: address = {}, port = {}, {}", new Object[]{tracker, hostAddress, port});
        try {
            this.retrieveIORText(hostAddress, IORport);
        }
        catch (Throwable e) {
            String reason = "failed to get the corba IOR from " + ipv4Addr;
            LOG.debug(reason, e);
            return PollStatus.unavailable((String)reason);
        }
        PollStatus status = null;
        tracker.reset();
        while (tracker.shouldRetry() && !status.isAvailable()) {
            String reason;
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                LOG.debug("DominoIIOPMonitor: connected to host: {} on port: {}", (Object)port, (Object)ipv4Addr);
                PollStatus pollStatus = PollStatus.up((Double)tracker.elapsedTimeInMillis());
                return pollStatus;
            }
            catch (NoRouteToHostException e) {
                reason = " No route to host exception for address " + hostAddress;
                LOG.debug(reason, (Throwable)e);
                status = PollStatus.unavailable((String)reason);
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host with " + tracker;
                LOG.debug(reason);
                status = PollStatus.unavailable((String)reason);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipv4Addr + " : " + e.getMessage();
                LOG.debug(reason);
                status = PollStatus.unavailable((String)reason);
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipv4Addr + " : " + e.getMessage();
                LOG.debug(reason);
                status = PollStatus.unavailable((String)reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    LOG.debug("DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                }
            }
            tracker.nextAttempt();
        }
        return status;
    }

    private String retrieveIORText(String host, int port) throws IOException {
        String IOR = "";
        URL u = new URL("http://" + host + ":" + port + "/diiop_ior.txt");
        InputStream is = u.openStream();
        BufferedReader dis = new BufferedReader(new InputStreamReader(is));
        boolean done = false;
        while (!done) {
            String line = dis.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            if (!(IOR = IOR + line).startsWith("IOR:")) continue;
            done = true;
        }
        dis.close();
        if (!IOR.startsWith("IOR:")) {
            throw new IOException("Invalid IOR: " + IOR);
        }
        return IOR;
    }
}

