/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class DiskUsageMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(DiskUsageMonitor.class);
    private static final String m_serviceName = "DISK-USAGE";
    private static final String hrStorageDescr = ".1.3.6.1.2.1.25.2.3.1.3";
    private static final String hrStorageSize = ".1.3.6.1.2.1.25.2.3.1.5";
    private static final String hrStorageUsed = ".1.3.6.1.2.1.25.2.3.1.6";
    private static final int MATCH_TYPE_EXACT = 0;
    private static final int MATCH_TYPE_STARTSWITH = 1;
    private static final int MATCH_TYPE_ENDSWITH = 2;
    private static final int MATCH_TYPE_REGEX = 3;

    public String serviceName() {
        return m_serviceName;
    }

    @Override
    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException ex) {
            LOG.error("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Override
    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        int matchType = 0;
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        String diskName = ParameterMap.getKeyedString(parameters, (String)"disk", null);
        Integer percentFree = ParameterMap.getKeyedInteger(parameters, (String)"free", (int)15);
        String matchTypeStr = ParameterMap.getKeyedString(parameters, (String)"match-type", (String)"exact");
        if (matchTypeStr.equalsIgnoreCase("exact")) {
            matchType = 0;
        } else if (matchTypeStr.equalsIgnoreCase("startswith")) {
            matchType = 1;
        } else if (matchTypeStr.equalsIgnoreCase("endswith")) {
            matchType = 2;
        } else if (matchTypeStr.equalsIgnoreCase("regex")) {
            matchType = 3;
        } else {
            throw new RuntimeException("Unknown value '" + matchTypeStr + "' for parameter 'match-type'");
        }
        LOG.debug("diskName=", (Object)diskName);
        LOG.debug("percentfree=", (Object)percentFree);
        LOG.debug("matchType=", (Object)matchTypeStr);
        LOG.debug("poll: service= SNMP address= {}", (Object)agentConfig);
        try {
            LOG.debug("DiskUsageMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId hrStorageDescrSnmpObject = SnmpObjId.get((String)hrStorageDescr);
            Map flagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"DiskUsagePoller", (SnmpObjId)hrStorageDescrSnmpObject);
            if (flagResults.size() == 0) {
                LOG.debug("SNMP poll failed: no results, addr={} oid={}", (Object)hostAddress, (Object)hrStorageDescrSnmpObject);
                return PollStatus.unavailable();
            }
            boolean foundDisk = false;
            for (Map.Entry e : flagResults.entrySet()) {
                foundDisk = true;
                LOG.debug("poll: SNMPwalk poll succeeded, addr={} oid={} instance={} value={}", new Object[]{hostAddress, hrStorageDescrSnmpObject, e.getKey(), e.getValue()});
                if (!this.isMatch(((SnmpValue)e.getValue()).toString(), diskName, matchType)) continue;
                LOG.debug("DiskUsageMonitor.poll: found disk=", (Object)diskName);
                SnmpObjId hrStorageSizeSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.25.2.3.1.5." + ((SnmpInstId)e.getKey()).toString()));
                SnmpObjId hrStorageUsedSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.25.2.3.1.6." + ((SnmpInstId)e.getKey()).toString()));
                SnmpValue snmpSize = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)hrStorageSizeSnmpObject);
                SnmpValue snmpUsed = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)hrStorageUsedSnmpObject);
                float calculatedPercentage = ((float)snmpSize.toLong() - (float)snmpUsed.toLong()) / (float)snmpSize.toLong() * 100.0f;
                LOG.debug("DiskUsageMonitor: calculatedPercentage={} percentFree={}", (Object)Float.valueOf(calculatedPercentage), (Object)percentFree);
                if (calculatedPercentage < (float)percentFree.intValue()) {
                    return PollStatus.unavailable((String)(diskName + " usage high (" + (100 - (int)calculatedPercentage) + "%)"));
                }
                return status;
            }
            if (foundDisk) {
                return status;
            }
            LOG.debug("DiskUsageMonitor: no disks found");
            return PollStatus.unavailable((String)("could not find " + diskName + "in table"));
        }
        catch (NumberFormatException e) {
            String reason = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        catch (IllegalArgumentException e) {
            String reason = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable((String)reason);
        }
        catch (Throwable t) {
            String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, t);
            status = PollStatus.unavailable((String)reason);
        }
        return status;
    }

    private boolean isMatch(String candidate, String target, int matchType) {
        boolean matches = false;
        LOG.debug("isMessage: candidate is '{}', matching against target '{}'", (Object)candidate, (Object)target);
        if (matchType == 0) {
            LOG.debug("Attempting equality match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.equals(target);
        } else if (matchType == 1) {
            LOG.debug("Attempting startsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.startsWith(target);
        } else if (matchType == 2) {
            LOG.debug("Attempting endsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = candidate.endsWith(target);
        } else if (matchType == 3) {
            LOG.debug("Attempting endsWith match: candidate '{}', target '{}'", (Object)candidate, (Object)target);
            matches = Pattern.compile(target).matcher(candidate).find();
        }
        LOG.debug("isMatch: Match is positive");
        return matches;
    }
}

