/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

@Distributable
public class DNSResolutionMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(DNSResolutionMonitor.class);
    public static final String RESOLUTION_TYPE_PARM = "resolution-type";
    public static final String RT_V4 = "v4";
    public static final String RT_V6 = "v6";
    public static final String RT_BOTH = "both";
    public static final String RT_EITHER = "either";
    public static final String RESOLUTION_TYPE_DEFAULT = "either";

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String nodeLabel = svc.getNodeLabel();
        String resolutionType = ParameterMap.getKeyedString(parameters, (String)RESOLUTION_TYPE_PARM, (String)"either");
        boolean requireV4 = RT_V4.equalsIgnoreCase(resolutionType) || RT_BOTH.equals(resolutionType);
        boolean requireV6 = RT_V6.equalsIgnoreCase(resolutionType) || RT_BOTH.equals(resolutionType);
        try {
            String reason;
            long start = System.currentTimeMillis();
            InetAddress[] addrs = this.resolve(nodeLabel);
            long end = System.currentTimeMillis();
            boolean v4found = false;
            boolean v6found = false;
            for (InetAddress addr : addrs) {
                LOG.debug("Resolved {} to {}", (Object)nodeLabel, (Object)addr);
                if (addr instanceof Inet4Address) {
                    v4found = true;
                    continue;
                }
                if (!(addr instanceof Inet6Address)) continue;
                v6found = true;
            }
            if (!v4found && !v6found) {
                reason = "Unable to resolve " + nodeLabel;
                LOG.debug(reason);
                return PollStatus.unavailable((String)reason);
            }
            if (requireV4 && !v4found) {
                reason = nodeLabel + " could only be resolved to an IPv6 address";
                LOG.debug(reason);
                return PollStatus.unavailable((String)reason);
            }
            if (requireV6 && !v6found) {
                reason = nodeLabel + " could only be resolved to an IPv4 address";
                LOG.debug(reason);
                return PollStatus.unavailable((String)reason);
            }
            LOG.debug("Resolved {} correctly!", (Object)nodeLabel);
            return PollStatus.available((Double)Double.valueOf(end - start));
        }
        catch (TextParseException e) {
            String reason = "Unable to resolve " + nodeLabel + ": " + e.getMessage();
            LOG.debug(reason);
            return PollStatus.unavailable((String)reason);
        }
    }

    InetAddress[] resolve(String hostname) throws TextParseException {
        Record[] aaaaRecords = new Lookup(hostname, 28).run();
        Record[] aRecords = new Lookup(hostname, 1).run();
        InetAddress[] addrs = new InetAddress[(aaaaRecords == null ? 0 : aaaaRecords.length) + (aRecords == null ? 0 : aRecords.length)];
        int index = 0;
        if (aaaaRecords != null) {
            for (Record r : aaaaRecords) {
                addrs[index++] = ((AAAARecord)r).getAddress();
            }
        }
        if (aRecords != null) {
            for (Record r : aRecords) {
                addrs[index++] = ((ARecord)r).getAddress();
            }
        }
        return addrs;
    }
}

