/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TableTracker;

public class NetScalerGroupHealthMonitor
extends SnmpMonitorStrategy {
    private static final String SVC_GRP_MEMBER_STATE = ".1.3.6.1.4.1.5951.4.1.2.7.1.6";

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        PollStatus status = PollStatus.unavailable((String)("NetScalerGroupHealthMonitor: cannot determinate group health, addr=" + hostAddress));
        int groupHealth = ParameterMap.getKeyedInteger(parameters, (String)"group-health", (int)60);
        String groupName = ParameterMap.getKeyedString(parameters, (String)"group-name", null);
        if (groupName == null) {
            status.setReason("NetScalerGroupHealthMonitor no group-name defined, addr=" + hostAddress);
            this.log().warn("NetScalerGroupHealthMonitor.poll: No Service Name Defined! ");
            return status;
        }
        int snLength = groupName.length();
        StringBuffer serviceOidBuf = new StringBuffer(SVC_GRP_MEMBER_STATE);
        serviceOidBuf.append(".").append(Integer.toString(snLength));
        for (byte thisByte : groupName.getBytes()) {
            serviceOidBuf.append(".").append(Byte.toString(thisByte));
        }
        this.log().debug("For group name '" + groupName + "', OID to check is " + serviceOidBuf.toString());
        try {
            final SnmpObjId groupStateOid = SnmpObjId.get((String)serviceOidBuf.toString());
            final HashMap hostResults = new HashMap();
            RowCallback callback = new RowCallback(){

                public void rowCompleted(SnmpRowResult result) {
                    hostResults.put(result.getInstance(), result.getValue(groupStateOid));
                }
            };
            TableTracker tracker = new TableTracker(callback, new SnmpObjId[]{groupStateOid});
            SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"NetScalerGroupHealthMonitor", (CollectionTracker)tracker);
            walker.start();
            walker.waitFor();
            int totalServers = hostResults.size();
            if (totalServers == 0) {
                status = this.logDown(Level.DEBUG, "NetScalerGroupHealthMonitor poll failed: there are 0 servers on group " + groupName + " for " + hostAddress);
            }
            int activeServers = 0;
            for (SnmpValue v : hostResults.values()) {
                if (v.toInt() != 7) continue;
                ++activeServers;
            }
            double health = new Double(activeServers) / new Double(totalServers) * new Double(100.0);
            this.log().debug("There are " + activeServers + " of " + totalServers + " active servers (" + health + "%) on group " + groupName + " for NetScaler " + hostAddress);
            status = health >= (double)groupHealth ? PollStatus.available() : this.logDown(Level.DEBUG, "NetScalerGroupHealthMonitor poll failed: there are " + activeServers + " of " + totalServers + " servers active (" + health + "%) on group " + groupName + ", which is less than " + groupHealth + "% for " + hostAddress);
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + hostAddress, t);
        }
        return status;
    }
}

