/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.SipShowPeerAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.config.AmiPeerFactory;
import org.opennms.netmgt.config.ami.AmiAgentConfig;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;

public class AsteriskSIPPeerMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String DEFAULT_SIPPEER = "";

    @Override
    public void initialize(Map<String, Object> parameters) {
        try {
            AmiPeerFactory.init();
        }
        catch (Exception e) {
            this.log().fatal("Initalize: Failed to load AMI configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        String sipPeer = ParameterMap.getKeyedString(parameters, (String)"sip-peer", (String)DEFAULT_SIPPEER);
        if (sipPeer.equals(DEFAULT_SIPPEER)) {
            this.log().fatal("AsteriskMonitor: No sip-peer parameter in poller configuration");
            throw new RuntimeException("AsteriskMonitor: required parameter 'sip-peer' is not present in supplied properties.");
        }
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 0, 3000);
        AmiPeerFactory amiPeerFactory = AmiPeerFactory.getInstance();
        AmiAgentConfig amiConfig = amiPeerFactory.getAgentConfig(svc.getAddress());
        this.log().debug(svc.getSvcName() + ": Creating new AMI-Connection: " + svc.getIpAddr() + ":" + amiConfig.getPort() + ", " + amiConfig.getUsername() + "/" + amiConfig.getPassword());
        ManagerConnectionFactory factory = new ManagerConnectionFactory(svc.getIpAddr(), amiConfig.getPort(), amiConfig.getUsername(), amiConfig.getPassword());
        ManagerConnection managerConnection = amiConfig.getUseTls() ? factory.createSecureManagerConnection() : factory.createManagerConnection();
        managerConnection.setSocketTimeout(new Long(timeoutTracker.getTimeoutInMillis()).intValue());
        while (timeoutTracker.shouldRetry()) {
            timeoutTracker.nextAttempt();
            this.log().debug(svc.getSvcName() + ": Attempt " + timeoutTracker.getAttempt());
            try {
                this.log().debug(svc.getSvcName() + ": AMI login");
                managerConnection.login();
                this.log().debug(svc.getSvcName() + ": AMI sendAction SipShowPeer");
                ManagerResponse response = managerConnection.sendAction((ManagerAction)new SipShowPeerAction(sipPeer));
                if (response.getAttribute("Status") == null) {
                    this.log().debug(svc.getSvcName() + ": service status down");
                    return PollStatus.decode((String)"Down", (String)"State of SIP Peer is unknown, because it was not found on the Asterisk server");
                }
                this.log().debug(svc.getSvcName() + ": Response: " + response.getAttribute("Status"));
                this.log().debug(svc.getSvcName() + ": AMI logoff");
                managerConnection.logoff();
                if (response.getAttribute("Status").startsWith("OK")) {
                    this.log().debug(svc.getSvcName() + ": service status up");
                    return PollStatus.decode((String)"Up", (String)"OK");
                }
                this.log().debug(svc.getSvcName() + ": service status down");
                return PollStatus.decode((String)"Down", (String)("State of SIP Peer is " + response.getAttribute("Status") + " and not OK"));
            }
            catch (AuthenticationFailedException e) {
                this.log().error(svc.getSvcName() + ": AMI AuthenticationError: " + e.toString());
                return PollStatus.decode((String)"Down", (String)"Could not get the state of SIP Peer: AMI AuthenticationError");
            }
            catch (TimeoutException e) {
                this.log().debug(svc.getSvcName() + ": TimeOut reached: " + e.toString());
            }
            catch (SocketTimeoutException e) {
                this.log().debug(svc.getSvcName() + ": TimeOut reached: " + e.toString());
            }
            catch (Exception e) {
                this.log().error(svc.getSvcName() + ": Exception: " + e.toString());
                return PollStatus.decode((String)"Down", (String)("Could not get the state of SIP Peer: " + e.toString()));
            }
        }
        return PollStatus.decode((String)"Down", (String)"Could not get the state of SIP Peer: Timeout exceeded");
    }
}

