/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import antlr.StringUtils;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

@Distributable(value={DistributionContext.DAEMON})
public class HostResourceSwRunMonitor
extends SnmpMonitorStrategy {
    private static final String SERVICE_NAME = "HOST-RESOURCES";
    private static final String HOSTRESOURCE_SW_NAME_OID = ".1.3.6.1.2.1.25.4.2.1.2";
    private static final String HOSTRESOURCE_SW_STATUS_OID = ".1.3.6.1.2.1.25.4.2.1.7";

    public String serviceName() {
        return SERVICE_NAME;
    }

    @Override
    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Override
    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        boolean maxOk;
        boolean minOk;
        NetworkInterface iface = svc.getNetInterface();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        this.log().debug("poll: setting SNMP peer attribute for interface " + hostAddress);
        String serviceNameOid = ParameterMap.getKeyedString(parameters, (String)"service-name-oid", (String)HOSTRESOURCE_SW_NAME_OID);
        String serviceStatusOid = ParameterMap.getKeyedString(parameters, (String)"service-status-oid", (String)HOSTRESOURCE_SW_STATUS_OID);
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"service-name", null);
        String matchAll = ParameterMap.getKeyedString(parameters, (String)"match-all", (String)"false");
        String runLevel = ParameterMap.getKeyedString(parameters, (String)"run-level", (String)"2");
        int minServices = ParameterMap.getKeyedInteger(parameters, (String)"min-services", (int)-1);
        int maxServices = ParameterMap.getKeyedInteger(parameters, (String)"max-services", (int)-1);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: service= SNMP address= " + agentConfig);
        }
        PollStatus status = PollStatus.unavailable((String)("HostResourceSwRunMonitor service not found, addr=" + hostAddress + ", service-name=" + serviceName));
        int matches = 0;
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("HostResourceSwRunMonitor.poll: SnmpAgentConfig address: " + agentConfig);
            }
            if (serviceName == null) {
                status.setReason("HostResourceSwRunMonitor no service-name defined, addr=" + hostAddress);
                this.log().warn("HostResourceSwRunMonitor.poll: No Service Name Defined! ");
                return status;
            }
            if (minServices > 0 && maxServices > 0 && minServices >= maxServices) {
                String reason = "min-services(" + minServices + ") should be less than max-services(" + maxServices + ")";
                status.setReason("HostResourceSwRunMonitor " + reason + ", addr=" + hostAddress + ", service-name=" + serviceName);
                this.log().warn("HostResourceSwRunMonitor.poll: " + reason + ".");
                return status;
            }
            Map nameResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"HostResourceSwRunMonitor", (SnmpObjId)SnmpObjId.get((String)serviceNameOid));
            Map statusResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"HostResourceSwRunMonitor", (SnmpObjId)SnmpObjId.get((String)serviceStatusOid));
            for (SnmpInstId nameInstance : nameResults.keySet()) {
                if (!this.match(serviceName, HostResourceSwRunMonitor.stripExtraQuotes(((SnmpValue)nameResults.get(nameInstance)).toString()))) continue;
                ++matches;
                this.log().debug("poll: HostResourceSwRunMonitor poll succeeded, addr=" + hostAddress + ", service-name=" + serviceName + ", value=" + nameResults.get(nameInstance));
                if (this.meetsCriteria((SnmpValue)statusResults.get(nameInstance), "<=", runLevel)) {
                    status = PollStatus.available();
                    if (!"false".equals(matchAll)) continue;
                    return status;
                }
                status = this.logDown(Level.DEBUG, "HostResourceSwRunMonitor poll failed, addr=" + hostAddress + ", service-name=" + serviceName + ", status=" + statusResults.get(nameInstance));
                return status;
            }
            this.log().debug("poll: HostResourceSwRunMonitor the number of matches found for " + serviceName + " was " + matches);
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.ERROR, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.ERROR, "Invalid SNMP Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + hostAddress, t);
        }
        boolean bl = minServices > 0 ? matches >= minServices : (minOk = true);
        boolean bl2 = maxServices > 0 ? matches <= maxServices : (maxOk = true);
        if (!minOk && maxServices < 0) {
            status = this.logDown(Level.DEBUG, "HostResourceSwRunMonitor poll failed: service-count(" + matches + ") >= min-services(" + minServices + "), addr=" + hostAddress + ", service-name=" + serviceName);
        }
        if (!maxOk && minServices < 0) {
            status = this.logDown(Level.DEBUG, "HostResourceSwRunMonitor poll failed: service-count(" + matches + ") <= max-services(" + maxServices + "), addr=" + hostAddress + ", service-name=" + serviceName);
        }
        if (!(minOk && maxOk || minServices <= 0 || maxServices <= 0)) {
            status = this.logDown(Level.DEBUG, "HostResourceSwRunMonitor poll failed: min-services(" + minServices + ") >= service-count(" + matches + ") <= max-services(" + maxServices + "), addr=" + hostAddress + ", service-name=" + serviceName);
        }
        return status;
    }

    private boolean match(String expectedText, String currentText) {
        if (expectedText.startsWith("~")) {
            return currentText.matches(expectedText.replaceFirst("~", ""));
        }
        return currentText.equalsIgnoreCase(expectedText);
    }

    private static String stripExtraQuotes(String string) {
        return StringUtils.stripFrontBack((String)string, (String)"\"", (String)"\"");
    }
}

