/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SimpleResolver;

@Distributable
public final class DnsMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_PORT = 53;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int[] DEFAULT_FATAL_RESP_CODES = new int[]{2};

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 0, 5000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)53);
        String lookup = ParameterMap.getKeyedString(parameters, (String)"lookup", null);
        if ((lookup == null || lookup.length() == 0) && (lookup = InetAddressUtils.getLocalHostAddressAsString()) == null) {
            throw new UnsupportedOperationException("Unable to look up local host address.");
        }
        ArrayList<Integer> fatalCodes = new ArrayList<Integer>();
        for (int code : ParameterMap.getKeyedIntegerArray(parameters, (String)"fatal-response-codes", (int[])DEFAULT_FATAL_RESP_CODES)) {
            fatalCodes.add(code);
        }
        InetAddress addr = (InetAddress)iface.getAddress();
        PollStatus serviceStatus = null;
        serviceStatus = this.pollDNS(timeoutTracker, port, addr, lookup, fatalCodes);
        if (serviceStatus == null) {
            serviceStatus = this.logDown(Level.DEBUG, "Never received valid DNS response for address: " + addr);
        }
        return serviceStatus;
    }

    private PollStatus pollDNS(TimeoutTracker timeoutTracker, int port, InetAddress address, String lookup, List<Integer> fatalCodes) {
        String addr = InetAddressUtils.str((InetAddress)address);
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry()) {
            try {
                Name name = Name.fromString((String)lookup, (Name)Name.root);
                SimpleResolver resolver = new SimpleResolver();
                resolver.setAddress(new InetSocketAddress(addr, port));
                resolver.setLocalAddress((InetSocketAddress)null);
                double timeout = timeoutTracker.getSoTimeout() / 1000;
                resolver.setTimeout(timeout < 1.0 ? 1 : (int)timeout);
                Record question = Record.newRecord((Name)name, (int)1, (int)1);
                Message query = Message.newQuery((Record)question);
                timeoutTracker.startAttempt();
                Message response = resolver.send(query);
                double responseTime = timeoutTracker.elapsedTimeInMillis();
                Integer rcode = response.getHeader().getRcode();
                LogUtils.debugf((Object)this, (String)"received response code: %s", (Object[])new Object[]{rcode});
                if (fatalCodes.contains(rcode)) {
                    return this.logDown(Level.DEBUG, "Received an invalid DNS response for address: " + addr);
                }
                return this.logUp(Level.DEBUG, responseTime, "valid DNS request received, responseTime= " + responseTime + "ms");
            }
            catch (InterruptedIOException e) {
            }
            catch (NoRouteToHostException e) {
                return this.logDown(Level.WARN, "No route to host exception for address: " + addr, e);
            }
            catch (ConnectException e) {
                return this.logDown(Level.WARN, "Connection exception for address: " + addr, e);
            }
            catch (IOException e) {
                return this.logDown(Level.WARN, "IOException while polling address: " + addr + " " + e.getMessage(), e);
            }
            timeoutTracker.nextAttempt();
        }
        return this.logDown(Level.DEBUG, "Never received valid DNS response for address: " + addr);
    }
}

