/* Serverxmp.java

   COPYRIGHT 2013 KRUPCZAK.ORG, LLC.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA
 
   For more information, visit:
   http://www.krupczak.org/
*/

package org.krupczak.xmp;

import java.net.*;
import java.io.*;
import java.security.*;
import java.security.cert.*;
import javax.net.ssl.*;

/**
 *  XMP listener (server) 
 *  @author Bobby Krupczak, rdk@krupczak.org
 *  @version $Id$
 *  @see XmpListener
 *  @see XmpSession
 *  @see XmpMessage
 *  @see Xmp
 **/

public class Serverxmp implements Runnable
{
    public XmpSession aSession;

    private static void usage(String argv[]) {

	System.out.println("Usage: java Serverxmp addr[,port]");
        System.exit(-1);

    } /* usage */

    public Serverxmp(XmpSession aSession) {
	this.aSession = aSession;
    }

    public static void main(String argv[]) {
        int i;
        XmpListener listener;
        XmpSession clientSession;
        String aString;
        SocketOpts sockopts;
        int portNumber;
        String[] listenAddr;

        /* java and program name are not part of argv */
        if (argv.length < 1)
	    usage(argv);

        portNumber = Xmp.XMP_PORT;
        listenAddr = argv[0].split(",");
        if (listenAddr.length > 1) { 
           portNumber = Integer.valueOf(listenAddr[1]).intValue();
        }
        
        sockopts = new SocketOpts();

        listener = new XmpListener(sockopts,listenAddr[0],portNumber);

        System.out.println("Server wants client auth? "+
			   listener.getWantClientAuth());
        System.out.println("Server needs client auth? "+
			   listener.getNeedClientAuth());
        listener.setWantClientAuth(true);
        System.out.println("Server wants client auth? "+
			   listener.getWantClientAuth());

        System.out.println("Serverxmp started, listening for connections");

        while (true) {

          if ((clientSession = listener.listenForConnection()) == null) {
  	      System.out.println("Serverxmp session accept error");
              break;
          }
          else {
	      new Thread(new Serverxmp(clientSession)).start();
          }

        } /* while true, listen for connection requests */

    } /* main */

    public void run() 
    {
         System.out.println("Serverxmp accepted connection via "+
                             aSession.getSessionProto()+" over IPv"+
                             aSession.getIpVersion()+" from "+
                             aSession.getTargetAddr()+","+
                             aSession.getTargetPort());

         // wait for messages, process, and reply 
         XmpMessage aRequest, aReply; 
         int ret;

         while (true) {
         
 	   aRequest = aSession.recvMessage();
           if (aRequest != null) {
              System.out.println("Serverxmp: recv'd message using authenUser "+
                                 aSession.getAuthenUser());
              aRequest.dump();
           }
           else {
              System.out.println("Serverxmp: recv error "+
                                 aSession.getErrorStatus());         
              break;
           }

           // process and send reply; 
           // make a generic response and send
           aReply = new XmpMessage(Xmp.MSGTYPE_RESPONSE);
           aReply.setDecoded();
           aReply.setMessageID(aRequest.getMessageID());

           // add two variables to reply
           XmpVar[] vars = new XmpVar[] {
              new XmpVar("core","sysDescr","","Java Serverxmp tool",
                          Xmp.SYNTAX_DISPLAYSTRING),
   	      new XmpVar("core","sysObjectID","","1.3.6.1.4.1.16050",
                          Xmp.SYNTAX_DISPLAYSTRING),
           };
           aReply.setMIBVars(vars);

           if ((ret = aSession.sendMessage(aReply)) < 0) {
	       System.out.println("Serverxmp: send failed, "+ret);
           }

	 } /* while */

         System.out.println("Serverxmp: run finishing");

    } /* run */


} /* class Serverxmp */
