/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp;

import java.math.BigInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.krupczak.xmp.Xmp;
import org.krupczak.xmp.XmpMessage;
import org.krupczak.xmp.XmpSession;
import org.krupczak.xmp.XmpVar;
import org.opennms.netmgt.protocols.xmp.XmpUtilException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(XmpUtil.class);
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN_EQUALS = "<=";
    public static final String GREATER_THAN_EQUALS = ">=";
    public static final String EQUALS = "=";
    public static final String NOT_EQUAL = "!=";
    public static final String MATCHES = "~";

    private static boolean valueMeetsCriteria(XmpVar replyVar, String valueOperator, String valueOperand, boolean caseSensitive) throws XmpUtilException {
        Pattern valueRegex = null;
        if (MATCHES.equals(valueOperator)) {
            try {
                int flags = 0;
                if (!caseSensitive) {
                    flags |= 2;
                }
                valueRegex = Pattern.compile(valueOperand, flags);
            }
            catch (PatternSyntaxException e) {
                LOG.debug("Unable to initialize regular expression.", (Throwable)e);
            }
        }
        if (valueRegex != null && valueRegex.matcher(replyVar.getValue()).matches()) {
            LOG.debug("handleScalarQuery: Response value |{}| matches, returning true", (Object)replyVar.getValue());
            return true;
        }
        if (MATCHES.equals(valueOperator) && (valueRegex == null || "".equals(valueRegex))) {
            LOG.debug("handleScalarQuery: Doing regex match but regex is null or empty, considering value |{}| a match!", (Object)replyVar.getValue());
            return true;
        }
        if (!MATCHES.equals(valueOperator)) {
            if (valueOperand == null) {
                LOG.debug("valueMeetsCriteria: operand is null, so any non-error reply will match");
                if (replyVar.getValue() != null) {
                    LOG.debug("valueMeetsCriteria: non-null reply value |{}| considered a match", (Object)replyVar.getValue());
                    return true;
                }
                LOG.debug("valueMeetsCriteria: null reply NOT considered a match");
                return false;
            }
            if (valueOperand.matches("^-?[0-9]+$")) {
                BigInteger intOperand;
                BigInteger intValue;
                LOG.debug("valueMeetsCriteria: operand {} looks like an integer, treating with BigInteger", (Object)valueOperand);
                try {
                    intValue = new BigInteger(replyVar.getValue());
                    intOperand = new BigInteger(valueOperand);
                }
                catch (NumberFormatException nfe) {
                    LOG.error("Failed to parse operand {} or observed value {} as a BigInteger, giving up", (Object)valueOperand, (Object)replyVar.getValue());
                    LOG.info(nfe.getMessage());
                    throw new XmpUtilException("Operand '" + valueOperand + "' or observed value '" + replyVar.getValue() + "' is a malformed integer");
                }
                if (LESS_THAN.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) < 0;
                }
                if (GREATER_THAN.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) > 0;
                }
                if (LESS_THAN_EQUALS.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) <= 0;
                }
                if (GREATER_THAN_EQUALS.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) >= 0;
                }
                if (EQUALS.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) == 0;
                }
                if (NOT_EQUAL.equals(valueOperator)) {
                    return intValue.compareTo(intOperand) != 0;
                }
                LOG.error("Unknown value operator '{}', giving up", (Object)valueOperator);
                throw new XmpUtilException("Operator '" + valueOperator + "' unknown");
            }
            if (valueOperand.matches("^-?[0-9]+([,.]?[0-9]+)$")) {
                float floatOperand;
                float floatValue;
                LOG.debug("valueMeetsCriteria: operand {} looks like a float, treating with float", (Object)valueOperand);
                try {
                    floatValue = Float.parseFloat(valueOperand);
                    floatOperand = Float.parseFloat(valueOperand);
                }
                catch (NumberFormatException nfe) {
                    LOG.error("Failed to parse operand {} or observed value {} as a Float, giving up", (Object)valueOperand, (Object)replyVar.getValue());
                    LOG.info(nfe.getMessage());
                    throw new XmpUtilException("Operand '" + valueOperand + "' or observed value '" + replyVar.getValue() + "' is a malformed floating-point number");
                }
                if (LESS_THAN.equals(valueOperator)) {
                    return floatValue < floatOperand;
                }
                if (GREATER_THAN.equals(valueOperator)) {
                    return floatValue > floatOperand;
                }
                if (LESS_THAN_EQUALS.equals(valueOperator)) {
                    return floatValue <= floatOperand;
                }
                if (GREATER_THAN_EQUALS.equals(valueOperator)) {
                    return floatValue >= floatOperand;
                }
                if (EQUALS.equals(valueOperator)) {
                    return floatValue == floatOperand;
                }
                if (NOT_EQUAL.equals(valueOperator)) {
                    return floatValue != floatOperand;
                }
                LOG.error("Unknown value operator '{}', giving up", (Object)valueOperator);
                throw new XmpUtilException("Value operator '" + valueOperator + "' unknown");
            }
            LOG.debug("valueMeetsCriteria: operand {} looks non-numeric, treating with String", (Object)valueOperand);
            if (!EQUALS.equals(valueOperator)) {
                LOG.error("Value operator '{}' does not apply for non-numeric value operand '{}', giving up", (Object)valueOperator, (Object)valueOperand);
                throw new XmpUtilException("Value operator '" + valueOperator + "' does not apply for non-numeric value operand '" + valueOperand + "'");
            }
            if (caseSensitive) {
                return valueOperand.equals(replyVar.getValue());
            }
            return valueOperand.equalsIgnoreCase(replyVar.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handleScalarQuery: Response value |{}| does not match for value operator |{}| and value operand |{}|, returning false", new Object[]{replyVar.getValue(), valueOperator, valueOperand});
            throw new XmpUtilException("Response value '" + replyVar.getValue() + "' does not match for value operator '" + valueOperator + "' and value operand '" + valueOperand + "'");
        }
        return false;
    }

    public static boolean handleScalarQuery(XmpSession session, String mib, String object, String valueOperator, String valueOperand, boolean caseSensitive) throws XmpUtilException {
        XmpVar[] queryVars = new XmpVar[]{new XmpVar(mib, object, 13)};
        XmpMessage reply = session.queryVars(queryVars);
        if (reply == null) {
            LOG.warn("handleScalarQuery: query for object {} from MIB {} failed, {}", new Object[]{object, mib, Xmp.errorStatusToString((int)session.getErrorStatus())});
            return false;
        }
        LOG.debug("handleScalarQuery: query for object {} from MIB {} succeeded.", (Object)object, (Object)mib);
        XmpVar[] replyVars = reply.getMIBVars();
        if (replyVars[0].getMibName().equals(mib) && replyVars[0].getObjName().equals(object)) {
            return XmpUtil.valueMeetsCriteria(replyVars[0], valueOperator, valueOperand, caseSensitive);
        }
        LOG.error("Observed MIB name ({}) or object name ({}) does not match specified MIB name ({}) or object name ({}), giving up", new Object[]{replyVars[0].getMibName(), replyVars[0].getObjName(), mib, object});
        throw new XmpUtilException("Received unexpected response (MIB: " + replyVars[0].getMibName() + " Object: " + replyVars[0].getObjName());
    }

    public static boolean handleTableQuery(XmpSession session, String mib, String table, String object, String instance, Pattern instanceRegex, String valueOperator, String valueOperand, int minMatches, int maxMatches, boolean maxMatchesUnbounded, boolean caseSensitive) throws XmpUtilException {
        String[] tableInfo = new String[3];
        XmpVar[] queryVars = new XmpVar[1];
        int numMatches = 0;
        queryVars[0] = new XmpVar(mib, object, 13);
        tableInfo[0] = mib;
        tableInfo[1] = object;
        tableInfo[2] = instance;
        XmpMessage reply = session.queryTableVars(tableInfo, 0, queryVars);
        if (reply == null) {
            LOG.warn("handleTableQuery: query for object {} from MIB {} failed, {}", new Object[]{object, mib, Xmp.errorStatusToString((int)session.getErrorStatus())});
            throw new XmpUtilException("XMP query failed (MIB " + mib + ", object " + object + "): " + Xmp.errorStatusToString((int)session.getErrorStatus()));
        }
        XmpVar[] replyVars = reply.getMIBVars();
        LOG.debug("handleTableQuery: Got reply with {} variables", (Object)replyVars.length);
        for (XmpVar thisVar : replyVars) {
            String rowInstance = thisVar.getKey();
            if (instanceRegex != null && !instanceRegex.matcher(rowInstance).matches()) {
                LOG.debug("handleTableQuery: instance {} does not match, skipping this row.", (Object)rowInstance);
                continue;
            }
            if (instanceRegex == null) {
                LOG.debug("handleTableQuery: instance match not specified, evaluating value of instance {}", (Object)rowInstance);
            } else {
                LOG.debug("handleTableQuery: instance {} matches, evaluating value", (Object)rowInstance);
            }
            if (!XmpUtil.valueMeetsCriteria(thisVar, valueOperator, valueOperand, caseSensitive)) continue;
            ++numMatches;
        }
        if (numMatches >= minMatches) {
            LOG.debug("handleTableQuery: Found {} matches, meets specified minimum of {}", (Object)numMatches, (Object)minMatches);
            if (maxMatchesUnbounded) {
                LOG.debug("handleTableQuery: Maximum matches unbounded, returning true");
                return true;
            }
            if (numMatches <= maxMatches) {
                LOG.debug("handleTableQuery: Found {} matches, meets specified maximum of {}, returning true", (Object)numMatches, (Object)maxMatches);
                return true;
            }
            LOG.debug("handleTableQuery: Found {} matches, exceeds specified maximum of {}, returning false", (Object)numMatches, (Object)maxMatches);
            throw new XmpUtilException("Found too many value matches (" + numMatches + " > " + maxMatches + ") for condition " + mib + "." + object + " " + valueOperator + " " + valueOperand);
        }
        LOG.debug("Found only {} matches, too few to meet specified minimum of {}", (Object)numMatches, (Object)minMatches);
        throw new XmpUtilException("Found too few value matches (" + numMatches + " < " + minMatches + ") for condition " + mib + "." + object + " " + valueOperator + " " + valueOperand);
    }
}

