/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import org.opennms.netmgt.config.xmpConfig.XmpConfig;
import org.opennms.netmgt.protocols.xmp.config.XmpAgentConfig;
import org.opennms.netmgt.protocols.xmp.config.XmpConfigFactory;

public class XmpPeerFactory {
    private static XmpPeerFactory m_singleton;
    private static XmpConfig m_config;
    private static boolean m_loaded;

    private XmpPeerFactory() throws FileNotFoundException, IOException {
    }

    public static synchronized void init() throws FileNotFoundException, IOException {
        if (m_loaded) {
            return;
        }
        XmpConfigFactory.init();
        m_config = XmpConfigFactory.getInstance().getXmpConfig();
        m_singleton = new XmpPeerFactory();
        m_loaded = true;
    }

    public static synchronized void reload() throws FileNotFoundException, IOException {
        m_singleton = null;
        m_loaded = false;
        XmpConfigFactory.init();
        XmpPeerFactory.init();
    }

    public static synchronized XmpPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(XmpPeerFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public synchronized XmpAgentConfig getAgentConfig(InetAddress agentInetAddress) {
        XmpAgentConfig config = new XmpAgentConfig();
        config.setAuthenUser(m_config.getAuthenUser());
        config.setPort(m_config.getPort());
        config.setRetry(m_config.getRetry());
        config.setTimeout(m_config.getTimeout());
        return config;
    }

    static {
        m_loaded = false;
    }
}

