/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.krupczak.xmp.SocketOpts;
import org.krupczak.xmp.Xmp;
import org.krupczak.xmp.XmpMessage;
import org.krupczak.xmp.XmpSession;
import org.krupczak.xmp.XmpVar;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.AbstractServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;
import org.opennms.netmgt.collection.support.builder.InterfaceLevelResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.api.ResourceTypesDao;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.xmpConfig.XmpConfig;
import org.opennms.netmgt.config.xmpDataCollection.Group;
import org.opennms.netmgt.config.xmpDataCollection.MibObj;
import org.opennms.netmgt.config.xmpDataCollection.XmpCollection;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionFactory;
import org.opennms.netmgt.protocols.xmp.config.XmpAgentConfig;
import org.opennms.netmgt.protocols.xmp.config.XmpConfigFactory;
import org.opennms.netmgt.protocols.xmp.config.XmpPeerFactory;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpCollector
extends AbstractServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(XmpCollector.class);
    static final String SERVICE_NAME = "XMP";
    int xmpPort;
    int timeout;
    int retries;
    SocketOpts sockopts;
    String authenUser;
    private ResourceTypesDao m_resourceTypesDao;

    public XmpCollector() {
        LOG.debug("XmpCollector created");
        this.xmpPort = 5270;
        this.sockopts = new SocketOpts();
        this.authenUser = new String("xmpUser");
        this.timeout = 3000;
    }

    private boolean handleScalarQuery(String groupName, CollectionAgent agent, CollectionSetBuilder collectionSetBuilder, long oldUptime, XmpSession session, NodeLevelResource nodeLevelResource, XmpVar[] queryVars) {
        XmpMessage reply = session.queryVars(queryVars);
        if (reply == null) {
            LOG.warn("collect: query to {} failed, {}", (Object)agent, (Object)Xmp.errorStatusToString((int)session.getErrorStatus()));
            return false;
        }
        XmpVar[] vars = reply.getMIBVars();
        long newUptime = 0L;
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i].getMibName().equals("core") && vars[i].getObjName().equals("sysUpTime")) {
                newUptime = vars[i].getValueLong();
            }
            XmpVar xmpVar = vars[i];
            collectionSetBuilder.withAttribute((Resource)nodeLevelResource, groupName, xmpVar.getObjName(), xmpVar.getValue(), XmpCollector.getType(xmpVar));
        }
        if (newUptime > oldUptime) {
            collectionSetBuilder.disableCounterPersistence(false);
        }
        if (newUptime > 0L) {
            agent.setSavedSysUpTime(newUptime);
        }
        return true;
    }

    private boolean handleTableQuery(String groupName, String resourceType, CollectionAgent agent, CollectionSetBuilder collectionSetBuilder, String[] tableInfo, XmpSession session, NodeLevelResource nodeLevelResource, XmpVar[] queryVars) throws CollectionException {
        int numColumns = queryVars.length;
        String targetInstance = tableInfo[2];
        if (tableInfo[2] == null || tableInfo[2].length() == 0) {
            tableInfo[2] = new String("*");
            targetInstance = null;
        }
        LOG.debug("sending table query {},{},{} target: {}", new Object[]{tableInfo[0], tableInfo[1], tableInfo[2], targetInstance});
        XmpMessage reply = session.queryTableVars(tableInfo, 0, queryVars);
        if (reply == null) {
            LOG.warn("collect: query to {} failed, {}", (Object)agent, (Object)Xmp.errorStatusToString((int)session.getErrorStatus()));
            return false;
        }
        XmpVar[] vars = reply.getMIBVars();
        int numRows = vars.length / numColumns;
        LOG.info("query returned valid table data for {} numRows={} numColumns={}", new Object[]{groupName, numRows, numColumns});
        for (int i = 0; i < numRows; ++i) {
            String rowInstance = vars[i * numColumns].getKey();
            String instanceName = targetInstance != null ? targetInstance : rowInstance;
            String nodeTypeName = tableInfo[1];
            Resource resource = this.getResource(nodeLevelResource, nodeTypeName, resourceType, instanceName);
            LOG.debug("queryTable instance={}", (Object)rowInstance);
            for (int j = 0; j < numColumns; ++j) {
                XmpVar var = vars[i * numColumns + j];
                collectionSetBuilder.withAttribute(resource, groupName, var.getObjName(), var.getValue(), XmpCollector.getType(var));
            }
        }
        return true;
    }

    public void initialize() {
        XmpConfig protoConfig;
        LOG.debug("initialize(params) called");
        try {
            XmpCollectionFactory.init();
        }
        catch (Throwable e) {
            LOG.error("initialize: XmpCollectionFactory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        try {
            XmpPeerFactory.init();
        }
        catch (Throwable e) {
            LOG.error("initialize: XmpPeerFactory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        try {
            XmpConfigFactory.init();
        }
        catch (Throwable e) {
            LOG.error("initialize: config factory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        if (this.m_resourceTypesDao == null) {
            this.m_resourceTypesDao = (ResourceTypesDao)BeanUtils.getBean((String)"daoContext", (String)"resourceTypesDao", ResourceTypesDao.class);
        }
        if ((protoConfig = XmpConfigFactory.getInstance().getXmpConfig()).hasPort()) {
            this.xmpPort = protoConfig.getPort();
        }
        if (protoConfig.hasTimeout()) {
            this.timeout = protoConfig.getTimeout();
        }
        if (protoConfig.getAuthenUser() != null) {
            this.authenUser = protoConfig.getAuthenUser();
        }
        LOG.debug("initialize: authenUser '{}' port {}", (Object)this.authenUser, (Object)this.xmpPort);
        LOG.debug("initialize: keystore found? {}", (Object)this.sockopts.getKeystoreFound());
    }

    public String serviceName() {
        return SERVICE_NAME;
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        String collectionName;
        LOG.debug("collect agent {}", (Object)agent);
        long oldUptime = 0L;
        XmpAgentConfig peerConfig = XmpPeerFactory.getInstance().getAgentConfig((InetAddress)agent.getAddress());
        this.authenUser = peerConfig.getAuthenUser();
        this.timeout = (int)peerConfig.getTimeout();
        this.retries = peerConfig.getRetry();
        this.xmpPort = peerConfig.getPort();
        if (parameters.get("authenUser") != null) {
            this.authenUser = ParameterMap.getKeyedString(parameters, (String)"authenUser", null);
        }
        if (parameters.get("timeout") != null) {
            this.timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)3000);
        }
        if (parameters.get("retry") != null) {
            this.retries = ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)0);
        }
        parameters.get("collection");
        if (parameters.get("port") != null) {
            this.xmpPort = Integer.valueOf((String)parameters.get("port"));
        }
        if ((collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null)) == null) {
            LOG.warn("collect found no collectionName for {}", (Object)agent);
            return null;
        }
        LOG.debug("XmpCollector: collect {} from {}", (Object)collectionName, (Object)agent);
        CollectionSetBuilder collectionSetBuilder = new CollectionSetBuilder(agent).withStatus(CollectionStatus.FAILED).disableCounterPersistence(true);
        NodeLevelResource nodeLevelResource = new NodeLevelResource(agent.getNodeId());
        XmpCollection collection = XmpCollectionFactory.getInstance().getXmpCollection(collectionName);
        if (collection == null) {
            LOG.warn("collect found no matching collection for {}", (Object)agent);
            return collectionSetBuilder.build();
        }
        if (collection.getGroups().getGroup().length < 1) {
            LOG.info("No groups to collect.");
            return collectionSetBuilder.withStatus(CollectionStatus.SUCCEEDED).build();
        }
        oldUptime = agent.getSavedSysUpTime();
        LOG.debug("collect: attempting to open XMP session with {}:{},{}", new Object[]{agent.getAddress(), this.xmpPort, this.authenUser});
        this.sockopts.setConnectTimeout(this.timeout);
        XmpSession session = new XmpSession(this.sockopts, (InetAddress)agent.getAddress(), this.xmpPort, this.authenUser);
        if (session.isClosed()) {
            LOG.warn("collect unable to open XMP session with {}", (Object)agent);
            return collectionSetBuilder.build();
        }
        LOG.debug("collect: successfully opened XMP session with{}", (Object)agent);
        for (Group group : collection.getGroups().getGroup()) {
            String groupName = group.getName();
            MibObj[] mibObjects = group.getMibObj();
            XmpVar[] vars = new XmpVar[mibObjects.length];
            LOG.debug("collecting XMP group {} with {} mib objects", (Object)groupName, (Object)mibObjects.length);
            for (int i = 0; i < mibObjects.length; ++i) {
                vars[i] = new XmpVar(mibObjects[i].getMib(), mibObjects[i].getVar(), mibObjects[i].getInstance(), "", 13);
            }
            if (mibObjects[0].getTable() != null && mibObjects[0].getTable().length() != 0) {
                String[] tableInfo = new String[]{mibObjects[0].getMib(), mibObjects[0].getTable(), mibObjects[0].getInstance()};
                if (this.handleTableQuery(group.getName(), group.getResourceType(), agent, collectionSetBuilder, tableInfo, session, nodeLevelResource, vars)) continue;
                session.closeSession();
                return collectionSetBuilder.build();
            }
            if (this.handleScalarQuery(group.getName(), agent, collectionSetBuilder, oldUptime, session, nodeLevelResource, vars)) continue;
            session.closeSession();
            return collectionSetBuilder.build();
        }
        session.closeSession();
        collectionSetBuilder.withStatus(CollectionStatus.SUCCEEDED);
        LOG.debug("XMP collect finished for {}, uptime for {} is {}", new Object[]{collectionName, agent, agent.getSavedSysUpTime()});
        return collectionSetBuilder.build();
    }

    public RrdRepository getRrdRepository(String collectionName) {
        LOG.debug("XMP getRrdRepository called for {}", (Object)collectionName);
        return XmpCollectionFactory.getInstance().getRrdRepository(collectionName);
    }

    private static AttributeType getType(XmpVar var) {
        switch (var.getSyntax()) {
            case 1: {
                return AttributeType.COUNTER;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                return AttributeType.GAUGE;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                return AttributeType.STRING;
            }
        }
        return AttributeType.STRING;
    }

    protected static String sanitizeInstance(String instance) {
        String instanceValue = instance.replace('/', '_');
        instanceValue = instanceValue.replace('\\', '_');
        instanceValue = instanceValue.replace(':', '_');
        instanceValue = instanceValue.replace(' ', '_');
        return instanceValue;
    }

    protected Resource getResource(NodeLevelResource nodeLevelResource, String nodeTypeName, String resourceType, String instance) throws CollectionException {
        if ("node".equalsIgnoreCase(nodeTypeName)) {
            return nodeLevelResource;
        }
        String effectiveResourceType = resourceType == null || resourceType.length() == 0 ? null : resourceType;
        String effectiveInstance = instance != null ? XmpCollector.sanitizeInstance(instance) : null;
        if (effectiveResourceType != null) {
            ResourceType resourceTypeDef = this.m_resourceTypesDao.getResourceTypeByName(effectiveResourceType);
            if (resourceType == null) {
                throw new CollectionException("No resource type found with name '" + effectiveResourceType + "'.");
            }
            return new GenericTypeResource(nodeLevelResource, (org.opennms.netmgt.collection.api.ResourceType)resourceTypeDef, effectiveInstance);
        }
        return new InterfaceLevelResource(nodeLevelResource, effectiveInstance);
    }

    public void setResourceTypesDao(ResourceTypesDao resourceTypesDao) {
        this.m_resourceTypesDao = resourceTypesDao;
    }
}

