/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpCollectionSet
implements CollectionSet {
    private static final Logger LOG = LoggerFactory.getLogger(XmpCollectionSet.class);
    CollectionStatus status = CollectionStatus.SUCCEEDED;
    boolean ignorePersistVar = false;
    CollectionAgent agent;
    XmpCollectionResource collectionResource;
    Set<XmpCollectionResource> listOfResources;
    private Date m_timestamp;

    XmpCollectionSet(CollectionAgent agent) {
        this.agent = agent;
        this.listOfResources = new HashSet<XmpCollectionResource>();
    }

    public void addResource(XmpCollectionResource aResource) {
        this.listOfResources.add(aResource);
    }

    public Collection<XmpCollectionResource> getResources() {
        return this.listOfResources;
    }

    public CollectionAgent getCollectionAgent() {
        return this.agent;
    }

    public void setCollectionAgent(CollectionAgent agent) {
        this.agent = agent;
    }

    public CollectionStatus getStatus() {
        return this.status;
    }

    public void setStatus(CollectionStatus status) {
        this.status = status;
    }

    public void setStatusSuccess() {
        this.status = CollectionStatus.SUCCEEDED;
    }

    public void setStatusFailed() {
        this.status = CollectionStatus.FAILED;
    }

    public boolean ignorePersist() {
        return this.ignorePersistVar;
    }

    public void ignorePersistTrue() {
        this.ignorePersistVar = true;
    }

    public void ignorePersistFalse() {
        this.ignorePersistVar = false;
    }

    public void visit(CollectionSetVisitor visitor) {
        LOG.debug("XmpCollectionSet: visit starting for set {}", (Object)this.agent);
        visitor.visitCollectionSet((CollectionSet)this);
        for (XmpCollectionResource resource : this.getResources()) {
            resource.visit(visitor);
        }
        visitor.completeCollectionSet((CollectionSet)this);
    }

    public Date getCollectionTimestamp() {
        return this.m_timestamp;
    }

    public void setCollectionTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }
}

