/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.model.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpCollectionResource
extends AbstractCollectionResource {
    private static final Logger LOG = LoggerFactory.getLogger(XmpCollectionResource.class);
    private final String m_nodeTypeName;
    private final String m_instance;
    private final String m_resourceType;
    private final Set<AttributeGroup> m_listOfGroups;

    public XmpCollectionResource(CollectionAgent agent, String resourceType, String nodeTypeName, String instance) {
        super(agent);
        this.m_nodeTypeName = nodeTypeName;
        this.m_resourceType = resourceType == null || resourceType.length() == 0 ? null : resourceType;
        if (instance != null) {
            String instanceValue = instance.replace('/', '_');
            instanceValue = instanceValue.replace('\\', '_');
            instanceValue = instanceValue.replace(':', '_');
            this.m_instance = instanceValue = instanceValue.replace(' ', '_');
        } else {
            this.m_instance = null;
        }
        this.m_listOfGroups = new HashSet<AttributeGroup>();
    }

    public ResourcePath getPath() {
        ResourcePath nodeDir = this.m_agent.getStorageResourcePath();
        if (this.m_nodeTypeName.equalsIgnoreCase("node")) {
            return nodeDir;
        }
        if (this.m_resourceType != null) {
            ResourcePath.get((String[])new String[]{this.m_resourceType});
            return ResourcePath.get((String[])new String[]{this.m_instance});
        }
        return ResourcePath.get((String[])new String[]{this.m_instance});
    }

    public void addAttributeGroup(AttributeGroup aGroup) {
        this.m_listOfGroups.add(aGroup);
    }

    public String getInstance() {
        return this.m_instance;
    }

    public String getResourceTypeName() {
        return this.m_nodeTypeName;
    }

    public Collection<AttributeGroup> getGroups() {
        return this.m_listOfGroups;
    }

    public String toString() {
        return "XmpCollectionResource for " + this.m_agent + " resType=" + this.m_resourceType + " instance=" + this.m_instance + " nodeType=" + this.m_nodeTypeName;
    }

    public void visit(CollectionSetVisitor visitor) {
        LOG.debug("XmpCollectionResource: visit starting with {} attribute groups", (Object)this.getGroups().size());
        visitor.visitResource((CollectionResource)this);
        for (AttributeGroup ag : this.getGroups()) {
            ag.visit(visitor);
        }
        visitor.completeResource((CollectionResource)this);
        LOG.debug("XmpCollectionResource: visit finished for {}", (Object)this.m_agent);
    }
}

