/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import org.krupczak.xmp.Xmp;
import org.krupczak.xmp.XmpVar;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.support.AbstractCollectionAttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XmpCollectionAttributeType
extends AbstractCollectionAttributeType {
    private static final Logger LOG = LoggerFactory.getLogger(XmpCollectionAttributeType.class);
    XmpVar aVar;

    XmpCollectionAttributeType(XmpVar aVar, AttributeGroupType groupType) {
        super(groupType);
        this.aVar = aVar;
    }

    public void storeAttribute(CollectionAttribute attrib, Persister persister) {
        LOG.debug("XmpCollectionAttributeType: store {}", (Object)attrib);
        switch (this.aVar.getSyntax()) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 15: {
                persister.persistNumericAttribute(attrib);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                persister.persistStringAttribute(attrib);
                break;
            }
            default: {
                persister.persistStringAttribute(attrib);
            }
        }
    }

    public String getName() {
        return this.aVar.getObjName();
    }

    public String getType() {
        return Xmp.syntaxToString((int)this.aVar.getSyntax());
    }

    public String toString() {
        return "XmpCollectionAttributeType " + Xmp.syntaxToString((int)this.aVar.getSyntax());
    }
}

