/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.xmpDataCollection.XmpCollection;
import org.opennms.netmgt.config.xmpDataCollection.XmpDatacollectionConfig;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpCollectionFactory {
    private static XmpCollectionFactory instance;
    private static XmpDatacollectionConfig config;
    private static final Logger LOG;
    private String rrdPath;

    public static void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (instance == null) {
            File dataCfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.XMP_COLLECTION_CONFIG_FILE_NAME);
            instance = new XmpCollectionFactory(dataCfgFile.getPath());
        }
    }

    public static XmpCollectionFactory getInstance() {
        return instance;
    }

    public XmpCollectionFactory(String configFile) throws MarshalException, ValidationException, IOException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        config = (XmpDatacollectionConfig)Unmarshaller.unmarshal(XmpDatacollectionConfig.class, (Reader)new InputStreamReader((InputStream)cfgIn, "UTF-8"));
        ((InputStream)cfgIn).close();
        this.rrdPath = null;
        if (LOG.isDebugEnabled()) {
            XmpCollection[] collections;
            for (XmpCollection coll : collections = config.getXmpCollection()) {
                LOG.debug("XmpCollectionFactory: found collection {}", (Object)coll.getName());
            }
        }
    }

    public XmpCollectionFactory(Reader rdr) throws MarshalException, ValidationException, IOException {
        config = (XmpDatacollectionConfig)Unmarshaller.unmarshal(XmpDatacollectionConfig.class, (Reader)rdr);
        this.rrdPath = null;
    }

    public String getRrdPath() {
        this.rrdPath = config.getRrdRepository();
        if (this.rrdPath == null) {
            return null;
        }
        if (this.rrdPath.endsWith(File.separator)) {
            this.rrdPath = this.rrdPath.substring(0, this.rrdPath.length() - File.separator.length());
        }
        return this.rrdPath;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        XmpCollection collection = this.getXmpCollection(collectionName);
        if (this.rrdPath == null) {
            this.getRrdPath();
        }
        repo.setRrdBaseDir(new File(this.rrdPath));
        if (collection != null) {
            repo.setRraList(collection.getRrd().getRraCollection());
            repo.setStep(collection.getRrd().getStep());
            repo.setHeartBeat(2 * repo.getStep());
        } else {
            repo.setRraList(null);
            repo.setStep(-1);
            repo.setStep(-2);
        }
        return repo;
    }

    public XmpCollection getXmpCollection(String collectionName) {
        XmpCollection[] collections = config.getXmpCollection();
        XmpCollection theCollection = null;
        for (XmpCollection coll : collections) {
            if (!coll.getName().equalsIgnoreCase(collectionName)) continue;
            theCollection = coll;
            break;
        }
        return theCollection;
    }

    static {
        LOG = LoggerFactory.getLogger(XmpCollectionFactory.class);
    }
}

