/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.krupczak.xmp.SocketOpts;
import org.krupczak.xmp.Xmp;
import org.krupczak.xmp.XmpMessage;
import org.krupczak.xmp.XmpSession;
import org.krupczak.xmp.XmpVar;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.config.xmpConfig.XmpConfig;
import org.opennms.netmgt.config.xmpDataCollection.Group;
import org.opennms.netmgt.config.xmpDataCollection.MibObj;
import org.opennms.netmgt.config.xmpDataCollection.XmpCollection;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionAttribute;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionAttributeType;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionFactory;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionResource;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionSet;
import org.opennms.netmgt.protocols.xmp.config.XmpAgentConfig;
import org.opennms.netmgt.protocols.xmp.config.XmpConfigFactory;
import org.opennms.netmgt.protocols.xmp.config.XmpPeerFactory;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmpCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(XmpCollector.class);
    static final String SERVICE_NAME = "XMP";
    int xmpPort;
    int timeout;
    int retries;
    Set<CollectionAgent> setOfNodes;
    SocketOpts sockopts;
    String authenUser;

    public XmpCollector() {
        LOG.debug("XmpCollector created");
        this.setOfNodes = new HashSet<CollectionAgent>();
        this.xmpPort = 5270;
        this.sockopts = new SocketOpts();
        this.authenUser = new String("xmpUser");
        this.timeout = 3000;
    }

    private boolean handleScalarQuery(String groupName, XmpCollectionSet collectionSet, long oldUptime, XmpSession session, XmpCollectionResource scalarResource, XmpVar[] queryVars) {
        XmpMessage reply = session.queryVars(queryVars);
        if (reply == null) {
            LOG.warn("collect: query to {} failed, {}", (Object)collectionSet.getCollectionAgent(), (Object)Xmp.errorStatusToString((int)session.getErrorStatus()));
            return false;
        }
        AttributeGroupType agt = new AttributeGroupType(groupName, "ignore");
        AttributeGroup ag = new AttributeGroup((CollectionResource)scalarResource, agt);
        XmpVar[] vars = reply.getMIBVars();
        long newUptime = 0L;
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i].getMibName().equals("core") && vars[i].getObjName().equals("sysUpTime")) {
                newUptime = vars[i].getValueLong();
            }
            XmpCollectionAttributeType attribType = new XmpCollectionAttributeType(vars[i], agt);
            XmpCollectionAttribute aVar = new XmpCollectionAttribute(scalarResource, (CollectionAttributeType)attribType, vars[i]);
            ag.addAttribute((CollectionAttribute)aVar);
        }
        if (newUptime > oldUptime) {
            collectionSet.ignorePersistFalse();
        }
        if (newUptime > 0L) {
            collectionSet.getCollectionAgent().setSavedSysUpTime(newUptime);
        }
        scalarResource.addAttributeGroup(ag);
        return true;
    }

    private boolean handleTableQuery(String groupName, String resourceType, XmpCollectionSet collectionSet, String[] tableInfo, XmpSession session, XmpVar[] queryVars) {
        int numColumns = queryVars.length;
        String targetInstance = tableInfo[2];
        if (tableInfo[2] == null || tableInfo[2].length() == 0) {
            tableInfo[2] = new String("*");
            targetInstance = null;
        }
        LOG.debug("sending table query {},{},{} target: {}", new Object[]{tableInfo[0], tableInfo[1], tableInfo[2], targetInstance});
        XmpMessage reply = session.queryTableVars(tableInfo, 0, queryVars);
        if (reply == null) {
            LOG.warn("collect: query to {} failed, {}", (Object)collectionSet.getCollectionAgent(), (Object)Xmp.errorStatusToString((int)session.getErrorStatus()));
            return false;
        }
        XmpVar[] vars = reply.getMIBVars();
        int numRows = vars.length / numColumns;
        LOG.info("query returned valid table data for {} numRows={} numColumns={}", new Object[]{groupName, numRows, numColumns});
        for (int i = 0; i < numRows; ++i) {
            String rowInstance = vars[i * numColumns].getKey();
            XmpCollectionResource rowResource = targetInstance != null ? new XmpCollectionResource(collectionSet.getCollectionAgent(), resourceType, tableInfo[1], targetInstance) : new XmpCollectionResource(collectionSet.getCollectionAgent(), resourceType, tableInfo[1], rowInstance);
            AttributeGroupType agt = new AttributeGroupType(groupName, "all");
            AttributeGroup ag = new AttributeGroup((CollectionResource)rowResource, agt);
            LOG.debug("queryTable instance={}", (Object)rowInstance);
            for (int j = 0; j < numColumns; ++j) {
                XmpCollectionAttributeType attribType = new XmpCollectionAttributeType(vars[i * numColumns + j], agt);
                XmpCollectionAttribute aVar = new XmpCollectionAttribute(rowResource, (CollectionAttributeType)attribType, vars[i * numColumns + j]);
                ag.addAttribute((CollectionAttribute)aVar);
            }
            rowResource.addAttributeGroup(ag);
            collectionSet.addResource(rowResource);
            LOG.info("query table data adding row resource {}", (Object)rowResource);
        }
        return true;
    }

    public void initialize(Map<String, String> parameters) {
        LOG.debug("initialize(params) called");
        try {
            XmpCollectionFactory.init();
        }
        catch (Throwable e) {
            LOG.error("initialize: XmpCollectionFactory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        try {
            XmpPeerFactory.init();
        }
        catch (Throwable e) {
            LOG.error("initialize: XmpPeerFactory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        try {
            XmpConfigFactory.init();
        }
        catch (Throwable e) {
            LOG.error("initialize: config factory failed to initialize");
            throw new UndeclaredThrowableException(e);
        }
        File f = new File(XmpCollectionFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new RuntimeException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + XmpCollectionFactory.getInstance().getRrdPath());
        }
        XmpConfig protoConfig = XmpConfigFactory.getInstance().getXmpConfig();
        if (protoConfig.hasPort()) {
            this.xmpPort = protoConfig.getPort();
        }
        if (protoConfig.hasTimeout()) {
            this.timeout = protoConfig.getTimeout();
        }
        if (protoConfig.getAuthenUser() != null) {
            this.authenUser = protoConfig.getAuthenUser();
        }
        LOG.debug("initialize: authenUser '{}' port {}", (Object)this.authenUser, (Object)this.xmpPort);
        LOG.debug("initialize: keystore found? {}", (Object)this.sockopts.getKeystoreFound());
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        LOG.debug("initialize agent/params called for {}", (Object)agent);
        this.setOfNodes.add(agent);
    }

    public void release() {
        LOG.info("release()");
        this.setOfNodes = new HashSet<CollectionAgent>();
    }

    public void release(CollectionAgent agent) {
        LOG.info("release agent called for {}", (Object)agent);
        this.setOfNodes.remove(agent);
    }

    public String serviceName() {
        return SERVICE_NAME;
    }

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) {
        String collectionName;
        LOG.debug("collect agent {}", (Object)agent);
        long oldUptime = 0L;
        XmpAgentConfig peerConfig = XmpPeerFactory.getInstance().getAgentConfig((InetAddress)agent.getAddress());
        this.authenUser = peerConfig.getAuthenUser();
        this.timeout = (int)peerConfig.getTimeout();
        this.retries = peerConfig.getRetry();
        this.xmpPort = peerConfig.getPort();
        if (parameters.get("authenUser") != null) {
            this.authenUser = ParameterMap.getKeyedString(parameters, (String)"authenUser", null);
        }
        if (parameters.get("timeout") != null) {
            this.timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)3000);
        }
        if (parameters.get("retry") != null) {
            this.retries = ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)0);
        }
        parameters.get("collection");
        if (parameters.get("port") != null) {
            this.xmpPort = Integer.valueOf((String)parameters.get("port"));
        }
        if ((collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null)) == null) {
            LOG.warn("collect found no collectionName for {}", (Object)agent);
            return null;
        }
        LOG.debug("XmpCollector: collect {} from {}", (Object)collectionName, (Object)agent);
        XmpCollectionSet collectionSet = new XmpCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatusFailed();
        collectionSet.ignorePersistTrue();
        XmpCollectionResource scalarResource = new XmpCollectionResource(agent, null, "node", null);
        collectionSet.addResource(scalarResource);
        XmpCollection collection = XmpCollectionFactory.getInstance().getXmpCollection(collectionName);
        if (collection == null) {
            LOG.warn("collect found no matching collection for {}", (Object)agent);
            return collectionSet;
        }
        oldUptime = agent.getSavedSysUpTime();
        LOG.debug("collect: attempting to open XMP session with {}:{},{}", new Object[]{agent.getAddress(), this.xmpPort, this.authenUser});
        this.sockopts.setConnectTimeout(this.timeout);
        XmpSession session = new XmpSession(this.sockopts, (InetAddress)agent.getAddress(), this.xmpPort, this.authenUser);
        if (session.isClosed()) {
            LOG.warn("collect unable to open XMP session with {}", (Object)agent);
            return collectionSet;
        }
        LOG.debug("collect: successfully opened XMP session with{}", (Object)agent);
        for (Group group : collection.getGroups().getGroup()) {
            String groupName = group.getName();
            MibObj[] mibObjects = group.getMibObj();
            XmpVar[] vars = new XmpVar[mibObjects.length];
            LOG.debug("collecting XMP group {} with {} mib objects", (Object)groupName, (Object)mibObjects.length);
            for (int i = 0; i < mibObjects.length; ++i) {
                vars[i] = new XmpVar(mibObjects[i].getMib(), mibObjects[i].getVar(), mibObjects[i].getInstance(), "", 13);
            }
            if (mibObjects[0].getTable() != null && mibObjects[0].getTable().length() != 0) {
                String[] tableInfo = new String[]{mibObjects[0].getMib(), mibObjects[0].getTable(), mibObjects[0].getInstance()};
                if (this.handleTableQuery(group.getName(), group.getResourceType(), collectionSet, tableInfo, session, vars)) continue;
                session.closeSession();
                return collectionSet;
            }
            if (this.handleScalarQuery(group.getName(), collectionSet, oldUptime, session, scalarResource, vars)) continue;
            session.closeSession();
            return collectionSet;
        }
        session.closeSession();
        collectionSet.setStatus(1);
        LOG.debug("XMP collect finished for {}, uptime for {} is {}", new Object[]{collectionName, agent, agent.getSavedSysUpTime()});
        return collectionSet;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        LOG.debug("XMP getRrdRepository called for {}", (Object)collectionName);
        return XmpCollectionFactory.getInstance().getRrdRepository(collectionName);
    }
}

