/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.detector;

import java.net.InetAddress;
import java.util.Date;
import org.krupczak.xmp.SocketOpts;
import org.krupczak.xmp.XmpMessage;
import org.krupczak.xmp.XmpSession;
import org.krupczak.xmp.XmpVar;
import org.opennms.netmgt.config.xmpConfig.XmpConfig;
import org.opennms.netmgt.protocols.xmp.config.XmpConfigFactory;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class XmpDetector
implements SyncServiceDetector {
    private static final String DEFAULT_SERVICE_NAME = "XMP";
    private static final String XMP_DEFAULT_AUTH_USER = "xmpUser";
    private static final Logger LOG = LoggerFactory.getLogger(XmpDetector.class);
    private static int XMP_DEFAULT_TIMEOUT = 3000;
    private static int XMP_DEFAULT_RETRIES = 1;
    private SocketOpts sockopts;
    private int xmpPort;
    private int xmpTimeout;
    private int xmpRetries;
    private String xmpAuthenUser;
    private String xmpServiceName;
    private String ipMatch;
    private Date createTimeDate;

    public XmpDetector(String serviceName, int port) {
        this.xmpPort = port;
        this.xmpAuthenUser = XMP_DEFAULT_AUTH_USER;
        this.xmpTimeout = XMP_DEFAULT_TIMEOUT;
        this.xmpRetries = XMP_DEFAULT_RETRIES;
        this.sockopts = new SocketOpts();
        this.xmpServiceName = serviceName;
        this.ipMatch = null;
        this.createTimeDate = new Date();
        LOG.debug("XmpDetector created, service " + this.xmpServiceName + " at " + this.createTimeDate);
    }

    public XmpDetector() {
        this(DEFAULT_SERVICE_NAME, 5270);
    }

    public String getServiceName() {
        LOG.debug("XmpDetector: getServiceName");
        return this.xmpServiceName;
    }

    public void setServiceName(String newServiceName) {
        LOG.debug("XmpDetector: setServiceName to " + newServiceName);
        this.xmpServiceName = newServiceName;
    }

    public void init() {
        this.onInit();
    }

    public void onInit() {
        LOG.debug("XmpDetector: onInit starting");
        try {
            XmpConfigFactory.init();
            XmpConfig protoConfig = XmpConfigFactory.getInstance().getXmpConfig();
            if (protoConfig.hasPort()) {
                this.xmpPort = protoConfig.getPort();
            }
            if (protoConfig.hasTimeout()) {
                this.xmpTimeout = protoConfig.getTimeout();
            }
            if (protoConfig.getAuthenUser() != null) {
                this.xmpAuthenUser = protoConfig.getAuthenUser();
            }
            this.sockopts.setConnectTimeout(this.xmpTimeout);
        }
        catch (Throwable e) {
            LOG.error("XmpDetector: no config factory, using defaults");
        }
    }

    public int getPort() {
        LOG.trace("XmpDetector: getPort");
        return this.xmpPort;
    }

    public void setPort(int newPort) {
        LOG.trace("XmpDetector: setPort to " + newPort);
        this.xmpPort = newPort;
    }

    public void setIpMatch(String newIpMatch) {
        LOG.trace("XmpDetector: setIpMatch to " + newIpMatch);
        this.ipMatch = newIpMatch;
    }

    public String getIpMatch() {
        LOG.trace("XmpDetector: getIpMatch returning '" + this.ipMatch + "'");
        return this.ipMatch;
    }

    public int getTimeout() {
        LOG.trace("XmpDetector: getTimeout returning " + this.xmpTimeout);
        return this.xmpTimeout;
    }

    public void setTimeout(int newTimeout) {
        LOG.trace("XmpDetector: setTimeout to " + newTimeout);
        this.xmpTimeout = newTimeout;
        this.sockopts.setConnectTimeout(this.xmpTimeout);
    }

    public void dispose() {
        LOG.debug("XmpDetector: dispose invoked");
    }

    public final boolean isServiceDetected(InetAddress address) {
        LOG.debug("XmpDetector: isServiceDetected starting to query " + address);
        XmpSession aSession = new XmpSession(this.sockopts, address, this.xmpPort, this.xmpAuthenUser);
        if (aSession.isClosed()) {
            LOG.debug("XmpDetector: null session to " + address);
            return false;
        }
        LOG.debug("XmpDetector: isServiceDetected session established with " + address);
        XmpVar[] vars = new XmpVar[]{new XmpVar("core", "sysName", "", "", 13), new XmpVar("core", "sysDescr", "", "", 13), new XmpVar("core", "sysUpTime", "", "", 13), new XmpVar("core", "xmpdVersion", "", "", 13)};
        XmpMessage aReply = aSession.queryVars(vars);
        if (aReply == null) {
            LOG.debug("XmpDetector: isServiceDetected no vars from " + address);
            aSession.closeSession();
            return false;
        }
        aSession.closeSession();
        XmpVar[] replyVars = aReply.getMIBVars();
        if (replyVars == null) {
            LOG.debug("XmpDetector: isServiceDetected no replyVars for " + address);
            return false;
        }
        LOG.debug("XmpDetector: isServiceDetected " + address + " reports " + replyVars[0].getValue() + "," + replyVars[1].getValue());
        LOG.debug("XmpDetector: isServiceDetected true for " + address);
        return true;
    }
}

