/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.monitor;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.krupczak.xmp.SocketOpts;
import org.krupczak.xmp.XmpSession;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.xmpConfig.XmpConfig;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.netmgt.protocols.xmp.XmpUtil;
import org.opennms.netmgt.protocols.xmp.XmpUtilException;
import org.opennms.netmgt.protocols.xmp.config.XmpConfigFactory;

public class XmpMonitor
extends AbstractServiceMonitor {
    private static final int DEFAULT_PORT = 5270;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final String DEFAULT_AUTHEN_USER = "xmpUser";
    private static final String DEFAULT_REQUEST_TYPE = "GetRequest";
    private static final String DEFAULT_REQUEST_MIB = "core";
    private static final String DEFAULT_REQUEST_TABLE = "";
    private static final String DEFAULT_REQUEST_OBJECT = "sysObjectID";
    private static final String DEFAULT_REQUEST_INSTANCE = "*";
    private static final String DEFAULT_VALUE_MATCH = null;
    private static final String DEFAULT_INSTANCE_MATCH = null;
    private static final int DEFAULT_MIN_MATCHES = 1;
    private static final int DEFAULT_MAX_MATCHES = 1;
    private static final boolean DEFAULT_MAX_MATCHES_UNBOUNDED = true;
    private static final boolean DEFAULT_VALUE_CASE_SENSITIVE = false;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        XmpConfig protoConfig = XmpConfigFactory.getInstance().getXmpConfig();
        SocketOpts sockopts = new SocketOpts();
        int retry = protoConfig.hasRetry() ? protoConfig.getRetry() : 0;
        int timeout = protoConfig.hasTimeout() ? protoConfig.getTimeout() : 5000;
        int port = 5270;
        String authenUser = DEFAULT_AUTHEN_USER;
        String requestType = DEFAULT_REQUEST_TYPE;
        String mib = DEFAULT_REQUEST_MIB;
        String table = DEFAULT_REQUEST_TABLE;
        String object = DEFAULT_REQUEST_OBJECT;
        String instance = DEFAULT_REQUEST_INSTANCE;
        String instanceMatch = null;
        String valueOperator = "=";
        String valueOperand = null;
        int minMatches = 1;
        int maxMatches = 1;
        boolean maxMatchesUnbounded = true;
        boolean valueCaseSensitive = false;
        if (parameters != null) {
            retry = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)(protoConfig.hasRetry() ? protoConfig.getRetry() : 0));
            timeout = ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)(protoConfig.hasTimeout() ? protoConfig.getTimeout() : 5000));
            port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)5270);
            authenUser = ParameterMap.getKeyedString(parameters, (String)"authenUser", (String)DEFAULT_AUTHEN_USER);
            requestType = ParameterMap.getKeyedString(parameters, (String)"request-type", (String)DEFAULT_REQUEST_TYPE);
            mib = ParameterMap.getKeyedString(parameters, (String)"mib", (String)DEFAULT_REQUEST_MIB);
            table = ParameterMap.getKeyedString(parameters, (String)"table", (String)DEFAULT_REQUEST_TABLE);
            object = ParameterMap.getKeyedString(parameters, (String)"object", (String)DEFAULT_REQUEST_OBJECT);
            instance = ParameterMap.getKeyedString(parameters, (String)"instance", (String)DEFAULT_REQUEST_INSTANCE);
            instanceMatch = ParameterMap.getKeyedString(parameters, (String)"instance-match", (String)DEFAULT_INSTANCE_MATCH);
            valueOperator = ParameterMap.getKeyedString(parameters, (String)"value-operator", (String)"==");
            valueOperand = ParameterMap.getKeyedString(parameters, (String)"value-match", (String)DEFAULT_VALUE_MATCH);
            valueCaseSensitive = ParameterMap.getKeyedBoolean(parameters, (String)"value-case-sensitive", (boolean)false);
            minMatches = ParameterMap.getKeyedInteger(parameters, (String)"min-matches", (int)1);
            maxMatches = ParameterMap.getKeyedInteger(parameters, (String)"max-matches", (int)1);
            String maxMatchesUnboundedStr = ParameterMap.getKeyedString(parameters, (String)"max-matches", (String)"unbounded");
            maxMatchesUnbounded = maxMatchesUnboundedStr.equalsIgnoreCase("unbounded");
        }
        if (requestType.equalsIgnoreCase("SelectTableRequest")) {
            if (table.equals(DEFAULT_REQUEST_TABLE)) {
                throw new IllegalArgumentException("When performing a SelectTableRequest, table must be specified");
            }
            if (object.equals(DEFAULT_REQUEST_OBJECT)) {
                throw new IllegalArgumentException("When performing a SelectTableRequest, object must be specified and must be tabular");
            }
        } else if (requestType.equalsIgnoreCase(DEFAULT_REQUEST_TYPE)) {
            if (!table.equals(DEFAULT_REQUEST_TABLE)) {
                throw new IllegalArgumentException("When performing a GetRequest, table must not be specified");
            }
            if (!instance.equals(DEFAULT_REQUEST_INSTANCE)) {
                throw new IllegalArgumentException("When performing a GetRequest, instance must not be specified");
            }
        } else {
            throw new IllegalArgumentException("Unknown request type " + requestType + ", only GetRequest and SelectTableRequest are supported");
        }
        Pattern instanceRegex = null;
        try {
            if (instanceMatch != null) {
                instanceRegex = Pattern.compile(instanceMatch);
            }
        }
        catch (PatternSyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
        long startTime = System.currentTimeMillis();
        sockopts.setConnectTimeout(timeout);
        XmpSession session = new XmpSession(sockopts, ipaddr, port, authenUser);
        boolean result = false;
        if (requestType.equalsIgnoreCase("SelectTableRequest")) {
            try {
                result = XmpUtil.handleTableQuery(session, mib, table, object, instance, instanceRegex, valueOperator, valueOperand, minMatches, maxMatches, maxMatchesUnbounded, valueCaseSensitive);
            }
            catch (XmpUtilException e) {
                status = PollStatus.unavailable((String)e.getMessage());
            }
        } else if (requestType.equalsIgnoreCase(DEFAULT_REQUEST_TYPE)) {
            try {
                result = XmpUtil.handleScalarQuery(session, mib, object, valueOperator, valueOperand, valueCaseSensitive);
            }
            catch (XmpUtilException e) {
                status = PollStatus.unavailable((String)e.getMessage());
            }
        }
        if (result) {
            Double responseTime = new Double(System.currentTimeMillis() - startTime);
            status = PollStatus.available((Double)responseTime);
        }
        return status;
    }
}

