/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.capsd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.krupczak.xmp.SocketOpts;
import org.krupczak.xmp.XmpSession;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.config.xmpConfig.XmpConfig;
import org.opennms.netmgt.protocols.xmp.XmpUtil;
import org.opennms.netmgt.protocols.xmp.XmpUtilException;
import org.opennms.netmgt.protocols.xmp.config.XmpConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmpPlugin
extends AbstractPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(XmpPlugin.class);
    private static final String PROTOCOL_NAME = "XMP";
    private static final int DEFAULT_PORT = 5270;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final String DEFAULT_AUTHEN_USER = "xmpUser";
    private static final String DEFAULT_REQUEST_TYPE = "GetRequest";
    private static final String DEFAULT_REQUEST_MIB = "core";
    private static final String DEFAULT_REQUEST_TABLE = "";
    private static final String DEFAULT_REQUEST_OBJECT = "sysObjectID";
    private static final String DEFAULT_REQUEST_INSTANCE = "*";
    private static final String DEFAULT_VALUE_MATCH = null;
    private static final String DEFAULT_INSTANCE_MATCH = null;
    private static final int DEFAULT_MIN_MATCHES = 1;
    private static final int DEFAULT_MAX_MATCHES = 1;
    private static final boolean DEFAULT_MAX_MATCHES_UNBOUNDED = true;
    private static final boolean DEFAULT_VALUE_CASE_SENSITIVE = false;
    private static final String DEFAULT_VALUE_OPERAND = "=";

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected XMP checking not supported");
    }

    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        XmpConfig protoConfig = XmpConfigFactory.getInstance().getXmpConfig();
        SocketOpts sockopts = new SocketOpts();
        int retry = protoConfig.hasRetry() ? protoConfig.getRetry() : 0;
        int timeout = protoConfig.hasTimeout() ? protoConfig.getTimeout() : 5000;
        int port = 5270;
        String authenUser = DEFAULT_AUTHEN_USER;
        String requestType = DEFAULT_REQUEST_TYPE;
        String mib = DEFAULT_REQUEST_MIB;
        String table = DEFAULT_REQUEST_TABLE;
        String object = DEFAULT_REQUEST_OBJECT;
        String instance = DEFAULT_REQUEST_INSTANCE;
        String instanceMatch = null;
        String valueOperator = DEFAULT_VALUE_OPERAND;
        String valueOperand = DEFAULT_VALUE_OPERAND;
        int minMatches = 1;
        int maxMatches = 1;
        boolean maxMatchesUnbounded = true;
        boolean valueCaseSensitive = false;
        if (qualifiers != null) {
            retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)(protoConfig.hasRetry() ? protoConfig.getRetry() : 0));
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)(protoConfig.hasTimeout() ? protoConfig.getTimeout() : 5000));
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)5270);
            authenUser = ParameterMap.getKeyedString(qualifiers, (String)"authenUser", (String)DEFAULT_AUTHEN_USER);
            requestType = ParameterMap.getKeyedString(qualifiers, (String)"request-type", (String)DEFAULT_REQUEST_TYPE);
            mib = ParameterMap.getKeyedString(qualifiers, (String)"mib", (String)DEFAULT_REQUEST_MIB);
            table = ParameterMap.getKeyedString(qualifiers, (String)"table", (String)DEFAULT_REQUEST_TABLE);
            object = ParameterMap.getKeyedString(qualifiers, (String)"object", (String)DEFAULT_REQUEST_OBJECT);
            instance = ParameterMap.getKeyedString(qualifiers, (String)"instance", (String)DEFAULT_REQUEST_INSTANCE);
            instanceMatch = ParameterMap.getKeyedString(qualifiers, (String)"instance-match", (String)DEFAULT_INSTANCE_MATCH);
            valueOperator = ParameterMap.getKeyedString(qualifiers, (String)"value-operator", (String)"==");
            valueOperand = ParameterMap.getKeyedString(qualifiers, (String)"value-match", (String)DEFAULT_VALUE_MATCH);
            valueCaseSensitive = ParameterMap.getKeyedBoolean(qualifiers, (String)"value-case-sensitive", (boolean)false);
            minMatches = ParameterMap.getKeyedInteger(qualifiers, (String)"min-matches", (int)1);
            maxMatches = ParameterMap.getKeyedInteger(qualifiers, (String)"max-matches", (int)1);
            String maxMatchesUnboundedStr = ParameterMap.getKeyedString(qualifiers, (String)"max-matches", (String)"unbounded");
            maxMatchesUnbounded = maxMatchesUnboundedStr.equalsIgnoreCase("unbounded");
        }
        sockopts.setConnectTimeout(timeout);
        if (requestType.equalsIgnoreCase("SelectTableRequest")) {
            if (table.equals(DEFAULT_REQUEST_TABLE)) {
                throw new IllegalArgumentException("When performing a SelectTableRequest, table must be specified");
            }
            if (object.equals(DEFAULT_REQUEST_OBJECT)) {
                throw new IllegalArgumentException("When performing a SelectTableRequest, object must be specified and must be tabular");
            }
        } else if (requestType.equalsIgnoreCase(DEFAULT_REQUEST_TYPE)) {
            if (!table.equals(DEFAULT_REQUEST_TABLE)) {
                throw new IllegalArgumentException("When performing a GetRequest, table must not be specified");
            }
            if (!instance.equals(DEFAULT_REQUEST_INSTANCE)) {
                throw new IllegalArgumentException("When performing a GetRequest, instance must not be specified");
            }
        } else {
            throw new IllegalArgumentException("Unknown request type " + requestType + ", only GetRequest and SelectTableRequest are supported");
        }
        Pattern instanceRegex = null;
        try {
            if (instanceMatch != null) {
                instanceRegex = Pattern.compile(instanceMatch);
            }
        }
        catch (PatternSyntaxException e) {
            throw new UndeclaredThrowableException(e);
        }
        boolean result = false;
        XmpSession session = new XmpSession(sockopts, address, port, authenUser);
        if (requestType.equalsIgnoreCase("SelectTableRequest")) {
            try {
                result = XmpUtil.handleTableQuery(session, mib, table, object, instance, instanceRegex, valueOperator, valueOperand, minMatches, maxMatches, maxMatchesUnbounded, valueCaseSensitive);
            }
            catch (XmpUtilException e) {
                result = false;
            }
        } else if (requestType.equalsIgnoreCase(DEFAULT_REQUEST_TYPE)) {
            try {
                result = XmpUtil.handleScalarQuery(session, mib, object, valueOperator, valueOperand, valueCaseSensitive);
            }
            catch (XmpUtilException e) {
                result = false;
            }
        }
        return result;
    }
}

