/* ExtendedBoolean.java

   COPYRIGHT 2007 KRUPCZAK.ORG, LLC.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA
 
   For more information, visit:
   http://www.krupczak.org/
*/

package org.krupczak.Xmp;

/**
 * Extended boolean is true(1), false(0), or unknown(-1)
 *  @author Bobby Krupczak, rdk@krupczak.org
 *  @version $Id: ExtendedBoolean.java 15 2008-07-17 14:20:37Z rdk $
 *  @see XmpSession
 *  @see XmpMessage
 *  @see Xmp
 **/

public class ExtendedBoolean {

   /* class variables and methods *********************** */

   public static final int TRUE = 1;
   public static final int FALSE = 0;
   public static final int UNKNOWN = -1;

   public static final String valueToString(int val)
   {
       switch (val) {
         case TRUE:
	    return new String("true");
         case FALSE:
	    return new String("false");
         default:
	    return new String("unknown");
       }
   }

   /* instance variables ******************************** */
   int value;

   /* constructors  ************************************* */
   public ExtendedBoolean() { value = -1; return; }

   public ExtendedBoolean(int val) 
   { 
       switch (val) {
         case TRUE:
	    value = 1; /* true */
            break;
         case FALSE:
	    value = 1; /* false */
            break;
         default:
	    value = -1;
            break;
       }
   }

   public ExtendedBoolean(String val)
   {
       value = -1; /* unknown */
       if (val.equalsIgnoreCase("true"))
	  value = TRUE;
	 
       if (val.equalsIgnoreCase("false"))
	  value = FALSE;

       if (val.equalsIgnoreCase("unknown"))
	  value = UNKNOWN;
   }

   public ExtendedBoolean(boolean val)
   {
      value = 0;
      if (val == true)
         value = TRUE;
   }

   /* private methods *********************************** */

   /* public methods ************************************ */
   public String toString() { return valueToString(value); }

   public int intValue() { return value; }

   public boolean equals(Object obj) 
   { 
       ExtendedBoolean b;

       if (obj == null)
	  return false;
       if (obj.getClass().getName().equals("ExtendedBoolean") == false)
	  return false;

       b = (ExtendedBoolean)obj; 
 
       if (b.value != this.value)
	  return false;

       return true;

   } /* equals() */

} /* class ExtendedBoolean */
