/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.protocols.xmp.collector;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.protocols.xmp.collector.XmpCollectionResource;

public class XmpCollectionSet
implements CollectionSet {
    int status = 1;
    boolean ignorePersistVar = false;
    CollectionAgent agent;
    XmpCollectionResource collectionResource;
    Set<XmpCollectionResource> listOfResources;
    private Date m_timestamp;

    XmpCollectionSet(CollectionAgent agent) {
        this.agent = agent;
        this.listOfResources = new HashSet<XmpCollectionResource>();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void addResource(XmpCollectionResource aResource) {
        this.listOfResources.add(aResource);
    }

    public Collection<XmpCollectionResource> getResources() {
        return this.listOfResources;
    }

    public CollectionAgent getCollectionAgent() {
        return this.agent;
    }

    public void setCollectionAgent(CollectionAgent agent) {
        this.agent = agent;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatusSuccess() {
        this.status = 1;
    }

    public void setStatusFailed() {
        this.status = 2;
    }

    public boolean ignorePersist() {
        return this.ignorePersistVar;
    }

    public void ignorePersistTrue() {
        this.ignorePersistVar = true;
    }

    public void ignorePersistFalse() {
        this.ignorePersistVar = false;
    }

    public void visit(CollectionSetVisitor visitor) {
        this.log().debug("XmpCollectionSet: visit starting for set " + this.agent);
        visitor.visitCollectionSet((CollectionSet)this);
        for (XmpCollectionResource resource : this.getResources()) {
            resource.visit(visitor);
        }
        visitor.completeCollectionSet((CollectionSet)this);
    }

    public Date getCollectionTimestamp() {
        return this.m_timestamp;
    }

    public void setCollectionTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }
}

