/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.protocols.http.FormFields;
import org.opennms.protocols.xml.config.Content;
import org.opennms.protocols.xml.config.Header;
import org.opennms.protocols.xml.config.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUrlConnection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUrlConnection.class);
    private URL m_url;
    private Request m_request;
    private HttpClientWrapper m_clientWrapper;

    protected HttpUrlConnection(URL url, Request request) {
        super(url);
        this.m_url = url;
        this.m_request = request;
    }

    @Override
    public void connect() throws IOException {
        String[] userInfo;
        if (this.m_clientWrapper != null) {
            return;
        }
        this.m_clientWrapper = HttpClientWrapper.create();
        if (this.m_request != null) {
            String disableSslVerification;
            int retries;
            int timeout = this.m_request.getParameterAsInt("timeout");
            if (timeout > 0) {
                this.m_clientWrapper.setConnectionTimeout(Integer.valueOf(timeout)).setSocketTimeout(Integer.valueOf(timeout));
            }
            if ((retries = this.m_request.getParameterAsInt("retries")) == 0) {
                retries = this.m_request.getParameterAsInt("retry");
            }
            if (retries > 0) {
                this.m_clientWrapper.setRetries(Integer.valueOf(retries));
            }
            if (Boolean.parseBoolean(disableSslVerification = this.m_request.getParameter("disable-ssl-verification"))) {
                try {
                    this.m_clientWrapper.useRelaxedSSL("https");
                }
                catch (GeneralSecurityException e) {
                    LOG.warn("Failed to set up relaxed SSL.", (Throwable)e);
                }
            }
            if (this.m_request.getParameterAsBoolean("use-system-proxy")) {
                this.m_clientWrapper.useSystemProxySettings();
            }
        }
        this.m_clientWrapper.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding()).addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
        String[] stringArray = userInfo = this.m_url.getUserInfo() == null ? null : this.m_url.getUserInfo().split(":");
        if (userInfo != null && userInfo.length == 2) {
            String uname = URLDecoder.decode(userInfo[0], StandardCharsets.UTF_8.name());
            String pwd = URLDecoder.decode(userInfo[1], StandardCharsets.UTF_8.name());
            this.m_clientWrapper.addBasicCredentials(uname, pwd);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            List params;
            if (this.m_clientWrapper == null) {
                this.connect();
            }
            int port = this.m_url.getPort() > 0 ? this.m_url.getPort() : this.m_url.getDefaultPort();
            URIBuilder ub = new URIBuilder();
            ub.setPort(port);
            ub.setScheme(this.m_url.getProtocol());
            ub.setHost(this.m_url.getHost());
            ub.setPath(this.m_url.getPath());
            if (this.m_url.getQuery() != null && !this.m_url.getQuery().trim().isEmpty() && !(params = URLEncodedUtils.parse((String)this.m_url.getQuery(), (Charset)StandardCharsets.UTF_8)).isEmpty()) {
                ub.addParameters(params);
            }
            HttpGet request = null;
            if (this.m_request != null && this.m_request.getMethod().equalsIgnoreCase("post")) {
                Content cnt = this.m_request.getContent();
                HttpPost post = new HttpPost(ub.build());
                ContentType contentType = ContentType.create((String)cnt.getType());
                LOG.info("Processing POST request for {}", (Object)contentType);
                if (contentType.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                    FormFields fields = (FormFields)((Object)JaxbUtils.unmarshal(FormFields.class, (String)cnt.getData()));
                    post.setEntity((HttpEntity)fields.getEntity());
                } else {
                    StringEntity entity = new StringEntity(cnt.getData(), contentType);
                    post.setEntity((HttpEntity)entity);
                }
                request = post;
            } else {
                request = new HttpGet(ub.build());
            }
            if (this.m_request != null) {
                for (Header header : this.m_request.getHeaders()) {
                    request.addHeader(header.getName(), header.getValue());
                }
            }
            CloseableHttpResponse response = this.m_clientWrapper.execute((HttpUriRequest)request);
            return response.getEntity().getContent();
        }
        catch (Exception e) {
            throw new IOException("Can't retrieve " + this.m_url.getPath() + " from " + this.m_url.getHost() + " because " + e.getMessage(), e);
        }
    }

    public void disconnect() {
        IOUtils.closeQuietly((Closeable)this.m_clientWrapper);
        this.m_clientWrapper = null;
    }
}

