/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.dao.jaxb;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlDataCollectionConfig;
import org.opennms.protocols.xml.config.XmlSource;
import org.opennms.protocols.xml.dao.jaxb.XmlDataCollectionConfigDaoJaxb;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class XmlDataCollectionConfigDaoJaxbTest {
    @Test
    public void testAfterPropertiesSetWithNoConfigSet() {
        XmlDataCollectionConfigDaoJaxb dao = new XmlDataCollectionConfigDaoJaxb();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property configResource must be set and be non-null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testAfterPropertiesSetWithBogusFileResource() throws Exception {
        FileSystemResource resource = new FileSystemResource("/bogus-file");
        XmlDataCollectionConfigDaoJaxb dao = new XmlDataCollectionConfigDaoJaxb();
        dao.setConfigResource((Resource)resource);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new MarshallingResourceFailureException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testAfterPropertiesSetWithGoodConfigFile() throws Exception {
        XmlDataCollectionConfigDaoJaxb dao = new XmlDataCollectionConfigDaoJaxb();
        File xmlCollectionConfig = new File("src/test/resources/", "xml-datacollection-config.xml");
        Assert.assertTrue((String)"xml-datacollection-config.xml is readable", (boolean)xmlCollectionConfig.canRead());
        FileInputStream in = new FileInputStream(xmlCollectionConfig);
        dao.setConfigResource((Resource)new InputStreamResource((InputStream)in));
        dao.afterPropertiesSet();
        Assert.assertNotNull((String)"xml data collection should not be null", (Object)dao.getConfig());
    }

    @Test
    public void testAfterPropertiesSetWithNestedFiles() throws Exception {
        System.setProperty("opennms.home", "src/test/resources");
        XmlDataCollectionConfigDaoJaxb dao = new XmlDataCollectionConfigDaoJaxb();
        File xmlCollectionConfig = new File("src/test/resources/etc", "xml-datacollection-config.xml");
        Assert.assertTrue((String)"xml-datacollection-config.xml is readable", (boolean)xmlCollectionConfig.canRead());
        FileInputStream in = new FileInputStream(xmlCollectionConfig);
        dao.setConfigResource((Resource)new InputStreamResource((InputStream)in));
        dao.afterPropertiesSet();
        XmlDataCollectionConfig config = dao.getConfig();
        Assert.assertNotNull((String)"xml data collection should not be null", (Object)config);
        Assert.assertEquals((long)2L, (long)((XmlSource)((XmlDataCollection)config.getXmlDataCollections().get(0)).getXmlSources().get(0)).getXmlGroups().size());
        Assert.assertEquals((long)5L, (long)((XmlSource)((XmlDataCollection)config.getXmlDataCollections().get(1)).getXmlSources().get(0)).getXmlGroups().size());
    }
}

