/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import net.sf.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.protocols.http.FormField;
import org.opennms.protocols.http.FormFields;
import org.opennms.protocols.xml.config.Header;
import org.opennms.protocols.xml.config.Parameter;
import org.opennms.protocols.xml.config.Person;
import org.opennms.protocols.xml.config.Request;

public class ContentTest {
    @Test
    public void testXmlContent() throws Exception {
        String xml = "<request method='POST'>\n  <parameter name='retries' value='3'/>\n  <parameter name='timeout' value='5000'/>\n  <header name='User-Agent' value='Chrome'/>\n  <header name='Host' value='{nodeLabel}'/>\n  <content type='application/xml'><![CDATA[\n    <person><firstName>Alejandro</firstName><lastName>Galue</lastName></person>\n  ]]></content>\n</request>";
        Request request = (Request)JaxbUtils.unmarshal(Request.class, (String)xml);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)"Chrome", (Object)((Header)request.getHeaders().get(0)).getValue());
        Assert.assertEquals((Object)"3", (Object)((Parameter)request.getParameters().get(0)).getValue());
        Assert.assertEquals((Object)"application/xml", (Object)request.getContent().getType());
        String subXml = request.getContent().getData();
        Assert.assertNotNull((Object)subXml);
        Person p = (Person)JaxbUtils.unmarshal(Person.class, (String)subXml);
        Assert.assertEquals((Object)"Alejandro", (Object)p.getFirstName());
    }

    @Test
    public void testJsonContent() throws Exception {
        String xml = "<request method='POST'>\n  <parameter name='retries' value='3'/>\n  <parameter name='timeout' value='5000'/>\n  <header name='User-Agent' value='Chrome'/>\n  <header name='Host' value='{nodeLabel}'/>\n  <content type='application/json'><![CDATA[\n    { person: { firstName: 'Alejandro', lastName: 'Galue' } }  ]]></content>\n</request>";
        Request request = (Request)JaxbUtils.unmarshal(Request.class, (String)xml);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)"Chrome", (Object)((Header)request.getHeaders().get(0)).getValue());
        Assert.assertEquals((Object)"3", (Object)((Parameter)request.getParameters().get(0)).getValue());
        Assert.assertEquals((Object)"application/json", (Object)request.getContent().getType());
        String json = request.getContent().getData();
        JSONObject o = JSONObject.fromObject((Object)json);
        Person p = (Person)JSONObject.toBean((JSONObject)o.getJSONObject("person"), Person.class);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"Alejandro", (Object)p.getFirstName());
    }

    @Test
    public void testFormUrlencodedContent() throws Exception {
        String xml = "<request method='POST'>\n  <parameter name='retries' value='3'/>\n  <parameter name='timeout' value='5000'/>\n  <header name='User-Agent' value='Chrome'/>\n  <header name='Host' value='{nodeLabel}'/>\n  <content type='application/x-www-form-urlencoded'><![CDATA[\n    <form-fields>\n      <form-field name='firstName'>Alejandro</form-field>\n      <form-field name='lastName'>Galue</form-field>\n    </form-fields>\n  ]]></content>\n</request>";
        Request request = (Request)JaxbUtils.unmarshal(Request.class, (String)xml);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((Object)"Chrome", (Object)((Header)request.getHeaders().get(0)).getValue());
        Assert.assertEquals((Object)"3", (Object)((Parameter)request.getParameters().get(0)).getValue());
        Assert.assertEquals((Object)"application/x-www-form-urlencoded", (Object)request.getContent().getType());
        FormFields fields = (FormFields)JaxbUtils.unmarshal(FormFields.class, (String)request.getContent().getData());
        Assert.assertNotNull((Object)fields);
        Assert.assertNotNull((Object)fields.getEntity());
        Assert.assertEquals((Object)"Alejandro", (Object)((FormField)fields.get(0)).getValue());
    }
}

