/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DocumentNamespaceResolver
implements NamespaceContext {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNamespaceResolver.class);
    private Document m_document;
    private Map<String, String> m_prefixUriMap = new HashMap<String, String>();

    public DocumentNamespaceResolver(Document document) {
        this.m_document = document;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String ret = null;
        if ("".equals(prefix)) {
            LOG.debug("getNamespaceURI: no prefix");
            return this.m_document.lookupNamespaceURI(null);
        }
        if (this.m_prefixUriMap.containsKey(prefix)) {
            ret = this.m_prefixUriMap.get(prefix);
            LOG.debug("getNamespaceURI: found cached namespace uri for prefix {}: {}", (Object)prefix, (Object)ret);
        } else {
            ret = this.m_document.lookupNamespaceURI(prefix);
            LOG.debug("getNamespaceURI: found namespace uri for prefix {}: {} in doc.", (Object)prefix, (Object)ret);
            this.m_prefixUriMap.put(prefix, ret);
        }
        return ret;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.m_document.lookupPrefix(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        return null;
    }
}

