/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.xml.collector.XmlCollectionHandler;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlDataCollectionConfig;
import org.opennms.protocols.xml.config.XmlSource;
import org.opennms.protocols.xml.dao.XmlDataCollectionConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlCollector
extends AbstractRemoteServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(XmlCollector.class);
    private static final String XML_DATACOLLECTION_KEY = "xmlDatacollection";
    private static final String RRD_REPOSITORY_PATH_KEY = "rddRepositoryPath";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<XmlDataCollection>>("xmlDatacollection", XmlDataCollection.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));
    private static final Set<String> PROPERTY_BLACKLIST = Sets.newHashSet((Object[])new String[]{"SERVICE", "collection", "xml-collection", "handler-class"});
    private XmlDataCollectionConfigDao m_xmlCollectionDao;
    private NodeDao m_nodeDao;
    private final LoadingCache<XmlCollectionHandlerKey, XmlCollectionHandler> m_handlers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<XmlCollectionHandlerKey, XmlCollectionHandler>(){

        public XmlCollectionHandler load(XmlCollectionHandlerKey key) throws Exception {
            try {
                LOG.debug("initialize: instantiating XML collection handler {}", (Object)key.getHandlerClass());
                Class<?> clazz = Class.forName(key.getHandlerClass());
                XmlCollectionHandler handler = (XmlCollectionHandler)clazz.newInstance();
                handler.setServiceName(key.getServiceName());
                return handler;
            }
            catch (Exception e) {
                throw new CollectionException("Unable to instantiate XML Collection Handler " + key.getHandlerClass() + " because: " + e.getMessage(), (Throwable)e);
            }
        }
    });

    public XmlCollector() {
        super(TYPE_MAP);
    }

    public XmlDataCollectionConfigDao getXmlCollectionDao() {
        return this.m_xmlCollectionDao;
    }

    public void setXmlCollectionDao(XmlDataCollectionConfigDao xmlCollectionDao) {
        this.m_xmlCollectionDao = xmlCollectionDao;
    }

    public void initialize() throws CollectionInitializationException {
        LOG.debug("initialize: initializing XML collector");
        if (this.m_xmlCollectionDao == null) {
            this.m_xmlCollectionDao = (XmlDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"xmlDataCollectionConfigDao", XmlDataCollectionConfigDao.class);
        }
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        XmlCollectionHandler handler;
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        LOG.debug("getRuntimeAttributes: initializing XML collection handling using {} for collection agent {}", parameters, (Object)agent);
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"SERVICE", (String)"XML");
        String handlerClass = ParameterMap.getKeyedString(parameters, (String)"handler-class", (String)"org.opennms.protocols.xml.collector.DefaultXmlCollectionHandler");
        XmlCollectionHandlerKey key = new XmlCollectionHandlerKey(serviceName, handlerClass);
        try {
            handler = (XmlCollectionHandler)this.m_handlers.get((Object)key);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"xml-collection", null));
        if (collectionName == null) {
            throw new IllegalArgumentException("Parameter collection is required for the XML Collector!");
        }
        LOG.debug("getRuntimeAttributes: collecting XML data using collection {} for {}", (Object)collectionName, (Object)agent);
        XmlDataCollection collection = this.m_xmlCollectionDao.getDataCollectionByName(collectionName);
        if (collection == null) {
            throw new IllegalArgumentException("XML Collection " + collectionName + " does not exist.");
        }
        runtimeAttributes.put(XML_DATACOLLECTION_KEY, this.parseCollection(collection, handler, agent, parameters));
        runtimeAttributes.put(RRD_REPOSITORY_PATH_KEY, this.m_xmlCollectionDao.getConfig().getRrdRepository());
        return runtimeAttributes;
    }

    public XmlDataCollection parseCollection(XmlDataCollection collection, XmlCollectionHandler handler, CollectionAgent agent, Map<String, Object> parameters) {
        XmlDataCollection preparsedCollection = collection.clone();
        Map<String, String> filteredParameters = XmlCollector.filterParameters(parameters);
        for (XmlSource source : preparsedCollection.getXmlSources()) {
            String originalUrlStr = source.getUrl();
            String parsedUrlStr = handler.parseUrl(this.m_nodeDao, originalUrlStr, agent, collection.getXmlRrd().getStep(), filteredParameters);
            LOG.debug("parseCollection: original url: '{}', parsed url: '{}' ", (Object)originalUrlStr, (Object)parsedUrlStr);
            source.setUrl(parsedUrlStr);
            Request originalRequest = source.getRequest();
            Request parsedRequest = handler.parseRequest(this.m_nodeDao, originalRequest, agent, collection.getXmlRrd().getStep(), filteredParameters);
            LOG.debug("parseCollection: original request: '{}', parsed request: '{}' ", (Object)originalRequest, (Object)parsedRequest);
            source.setRequest(parsedRequest);
        }
        return preparsedCollection;
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        String rrdRepositoryPath = ParameterMap.getKeyedString(parameters, (String)RRD_REPOSITORY_PATH_KEY, null);
        XmlDataCollection collection = (XmlDataCollection)parameters.get(XML_DATACOLLECTION_KEY);
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"SERVICE", (String)"XML");
        String handlerClass = ParameterMap.getKeyedString(parameters, (String)"handler-class", (String)"org.opennms.protocols.xml.collector.DefaultXmlCollectionHandler");
        XmlCollectionHandlerKey key = new XmlCollectionHandlerKey(serviceName, handlerClass);
        try {
            RrdRepository rrdRepository = XmlDataCollectionConfig.buildRrdRepository(rrdRepositoryPath, collection);
            XmlCollectionHandler handler = (XmlCollectionHandler)this.m_handlers.get((Object)key);
            handler.setRrdRepository(rrdRepository);
            return handler.collect(agent, collection, parameters);
        }
        catch (Exception e) {
            throw new CollectionException("Can't collect XML data because " + e.getMessage(), (Throwable)e);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_xmlCollectionDao.getConfig().buildRrdRepository(collectionName);
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    protected static Map<String, String> filterParameters(Map<String, Object> input) {
        return input.entrySet().stream().filter(e -> !PROPERTY_BLACKLIST.contains(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ParameterMap.getKeyedString((Map)input, (String)((String)e.getKey()), (String)"")));
    }

    private static final class XmlCollectionHandlerKey {
        private final String serviceName;
        private final String handlerClass;

        public XmlCollectionHandlerKey(String serviceName, String handlerClass) {
            this.serviceName = Objects.requireNonNull(serviceName);
            this.handlerClass = Objects.requireNonNull(handlerClass);
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getHandlerClass() {
            return this.handlerClass;
        }

        public int hashCode() {
            return Objects.hash(this.serviceName, this.handlerClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof XmlCollectionHandlerKey)) {
                return false;
            }
            XmlCollectionHandlerKey other = (XmlCollectionHandlerKey)obj;
            return Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.handlerClass, other.handlerClass);
        }
    }
}

