/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.model.Row;
import org.opennms.netmgt.rrd.model.RrdConvertUtils;
import org.opennms.netmgt.rrd.model.v3.RRA;
import org.opennms.netmgt.rrd.model.v3.RRDv3;
import org.opennms.netmgt.rrd.rrdtool.JniRrdStrategy;
import org.opennms.protocols.xml.collector.XmlCollectorITCase;

public class NodeLevelDataWithRrdtoolTest
extends XmlCollectorITCase {
    @Override
    public String getConfigFileName() {
        return "src/test/resources/node-level-datacollection-config.xml";
    }

    @Override
    public String getSampleFileName() {
        return "src/test/resources/node-level.xml";
    }

    @Override
    protected RrdStrategy<?, ?> getRrdStrategy() throws Exception {
        this.setRrdBinary();
        this.setJniRrdLibrary();
        return new JniRrdStrategy();
    }

    protected void validateRrd(File file, String[] dsnames, Double[] dsvalues) throws Exception {
        Assert.assertTrue((boolean)file.exists());
        RRDv3 rrd = RrdConvertUtils.dumpRrd((File)file);
        Assert.assertEquals((long)dsnames.length, (long)rrd.getDataSources().size());
        for (int i = 0; i < dsnames.length; ++i) {
            Assert.assertEquals((Object)dsvalues[i], (Object)rrd.getDataSource(i).getLastDs());
            List rows = ((RRA)rrd.getRras().get(0)).getRows();
            Assert.assertFalse((boolean)((Row)rows.get(rows.size() - 1)).isNan());
        }
    }

    protected void setRrdBinary() {
        String[] rrdLocations;
        for (String location : rrdLocations = new String[]{"/opt/local/bin/rrdtool", "/sw/bin/rrdtool", "/usr/bin/rrdtool", "/usr/local/rrdtool/bin/rrdtool", "/opt/csw/bin/rrdtool"}) {
            File file = new File(location);
            if (!file.exists()) continue;
            System.setProperty("rrd.binary", file.getAbsolutePath());
            System.err.printf("setRrdBinary: found rrdtool binary at %s\n", file.getAbsolutePath());
            return;
        }
        throw new RuntimeException("Can't find RRDTOOL binary file");
    }

    protected void setJniRrdLibrary() {
        String[] rrdLocations;
        for (String location : rrdLocations = new String[]{"/opt/jrrd/lib/libjrrd.jnilib", "/opt/local/lib/libjrrd.jnilib", "/usr/lib/libjrrd.so", "/usr/lib64/libjrrd.so", "/usr/local/lib/libjrrd.so"}) {
            File file = new File(location);
            if (!file.exists()) continue;
            System.setProperty("opennms.library.jrrd", file.getAbsolutePath());
            System.setProperty("org.opennms.rrd.usejni", "true");
            System.err.printf("setJniRrdLibrary: found jrrd binary at %s\n", file.getAbsolutePath());
            return;
        }
        throw new RuntimeException("Can't find JNI RRD or JRRD Jar Library file)");
    }

    @Test
    @Ignore
    public void testDefaultXmlCollector() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "NodeLevel");
        parameters.put("handler-class", "org.opennms.protocols.xml.collector.MockDefaultXmlCollectionHandler");
        for (int i = 0; i < 4; ++i) {
            this.executeCollectorTest(parameters, 1);
            Thread.sleep(1000L);
        }
        File file = new File("target/snmp/1/node-level-stats.rrd");
        Assert.assertTrue((boolean)file.exists());
        String[] dsnames = new String[]{"v1", "v2", "v3", "v4", "v5", "v6"};
        Double[] dsvalues = new Double[]{10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
        this.validateRrd(file, dsnames, dsvalues);
    }
}

