/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.protocols.xml.collector.Sftp3gppUtils;

public class Sftp3gppUtilsTest {
    @Test
    public void testParser() throws Exception {
        String format = Sftp3gppUtils.get3gppFormat((String)"cdmaSc");
        Assert.assertEquals((Object)"system|/=/v=1/sg-name=<mmeScSgName>|", (Object)format);
        Map properties = Sftp3gppUtils.get3gppProperties((String)format, (String)"system|/=/v=1/sg-name=GA|");
        Assert.assertEquals((long)3L, (long)properties.size());
        Assert.assertEquals((Object)"system|/=/v=1/sg-name=GA|", properties.get("instance"));
        Assert.assertEquals((Object)"GA", properties.get("sg-name"));
        Assert.assertEquals((Object)"sg-name=GA", properties.get("label"));
        format = Sftp3gppUtils.get3gppFormat((String)"gbBssgp");
        Assert.assertEquals((Object)"nse|/=/v=1/nse-id=<nseNumber>|/=/v=1/sg-name=<sgsnGtlSgName>/su-number=<n>", (Object)format);
        properties = Sftp3gppUtils.get3gppProperties((String)format, (String)"nse|/=/v=1/nse-id=1201|/=/v=1/sg-name=GB71/su-number=1");
        Assert.assertEquals((long)5L, (long)properties.size());
        Assert.assertEquals((Object)"nse|/=/v=1/nse-id=1201|/=/v=1/sg-name=GB71/su-number=1", properties.get("instance"));
        Assert.assertEquals((Object)"1201", properties.get("nse-id"));
        Assert.assertEquals((Object)"GB71", properties.get("sg-name"));
        Assert.assertEquals((Object)"1", properties.get("su-number"));
        Assert.assertEquals((Object)"nse-id=1201, sg-name=GB71, su-number=1", properties.get("label"));
        format = Sftp3gppUtils.get3gppFormat((String)"platformSystemFilesystem");
        Assert.assertEquals((Object)"disk|/=/v=1/frame=<frame>/shelf=<shelf>/slot=<slot>/sub-slot=<sub-slot>/name=<directory path>|", (Object)format);
        properties = Sftp3gppUtils.get3gppProperties((String)format, (String)"disk|/=/v=1/frame=0/shelf=0/slot=2/sub-slot=0/name=\\/opt\\/hitachi\\/agw\\/data\\/trace|");
        Assert.assertEquals((long)7L, (long)properties.size());
        Assert.assertEquals((Object)"0", properties.get("frame"));
        Assert.assertEquals((Object)"0", properties.get("shelf"));
        Assert.assertEquals((Object)"2", properties.get("slot"));
        Assert.assertEquals((Object)"0", properties.get("sub-slot"));
        Assert.assertEquals((Object)"/opt/hitachi/agw/data/trace", properties.get("name"));
        Assert.assertEquals((Object)"frame=0, shelf=0, slot=2, sub-slot=0, name=/opt/hitachi/agw/data/trace", properties.get("label"));
    }

    @Test
    public void testNMS6365() throws Exception {
        String format = Sftp3gppUtils.get3gppFormat((String)"dnsDns");
        Map properties = Sftp3gppUtils.get3gppProperties((String)format, (String)"system|/service=callp1|");
        Assert.assertEquals((Object)"system|/service=callp1|", properties.get("label"));
        System.setProperty("org.opennms.collectd.xml.3gpp.useSimpleParserForMeasObjLdn", "true");
        properties = Sftp3gppUtils.get3gppProperties((String)format, (String)"system|/service=callp1|");
        Assert.assertEquals((Object)"/service=callp1", properties.get("label"));
    }
}

