/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.json.collector;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.json.JSONObject;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.protocols.json.collector.JsonCollectorITCase;
import org.opennms.protocols.json.collector.MockDocumentBuilder;

public class JsonCollectorArrayIT
extends JsonCollectorITCase {
    @Override
    public String getConfigFileName() {
        return "src/test/resources/json-array-datacollection-config.xml";
    }

    @Override
    public String getSampleFileName() {
        return "src/test/resources/array.json";
    }

    @Test
    public void testXpath() throws Exception {
        JSONObject json = MockDocumentBuilder.getJSONDocument();
        JXPathContext context = JXPathContext.newContext((Object)json);
        Iterator itr = context.iteratePointers("/elements[4]/it");
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertEquals((Object)((Pointer)itr.next()).getValue(), (Object)"works");
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testJsonCollector() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "json-array");
        parameters.put("handler-class", "org.opennms.protocols.json.collector.MockDefaultJsonCollectionHandler");
        this.executeCollectorTest(parameters, 4);
        Assert.assertTrue((boolean)new File(this.getSnmpRootDirectory(), "1/jsonArrayStats/foo/json-array-stats.jrb").exists());
        Assert.assertTrue((boolean)new File(this.getSnmpRootDirectory(), "1/jsonArrayStats/bar/json-array-stats.jrb").exists());
        Assert.assertTrue((boolean)new File(this.getSnmpRootDirectory(), "1/jsonArrayStats/baz/json-array-stats.jrb").exists());
        Assert.assertTrue((boolean)new File(this.getSnmpRootDirectory(), "1/jsonArrayStats/works/json-array-stats.jrb").exists());
        this.validateJrb(new File(this.getSnmpRootDirectory(), "1/jsonArrayStats/foo/json-array-stats.jrb"), new String[]{"val"}, new Double[]{0.0});
        this.validateJrb(new File(this.getSnmpRootDirectory(), "1/jsonArrayStats/bar/json-array-stats.jrb"), new String[]{"val"}, new Double[]{1.0});
        this.validateJrb(new File(this.getSnmpRootDirectory(), "1/jsonArrayStats/baz/json-array-stats.jrb"), new String[]{"val"}, new Double[]{2.0});
        this.validateJrb(new File(this.getSnmpRootDirectory(), "1/jsonArrayStats/works/json-array-stats.jrb"), new String[]{"val"}, new Double[]{1337.0});
    }
}

