/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.protocols.xml.collector.DocumentNamespaceResolver;
import org.opennms.protocols.xml.collector.MockDocumentBuilder;
import org.opennms.protocols.xml.collector.XmlCollectorITCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlCollectorNamespaceTest
extends XmlCollectorITCase {
    @Override
    public String getConfigFileName() {
        return "src/test/resources/namespace-datacollection-config.xml";
    }

    @Override
    public String getSampleFileName() {
        return "src/test/resources/namespace.xml";
    }

    @Test
    public void testXpath() throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Document doc = MockDocumentBuilder.getXmlDocument();
        DocumentNamespaceResolver dnr = new DocumentNamespaceResolver(doc);
        xpath.setNamespaceContext((NamespaceContext)dnr);
        NodeList resourceList = (NodeList)xpath.evaluate("/dp:RootElement/dp:ChildElement/dp:StatList", doc, XPathConstants.NODESET);
        for (int j = 0; j < resourceList.getLength(); ++j) {
            Node resource = resourceList.item(j);
            Node resourceID = (Node)xpath.evaluate("dp:Stat[@Name = 'ID']", resource, XPathConstants.NODE);
            Assert.assertNotNull((Object)resourceID);
            String value = (String)xpath.evaluate("dp:Stat[@Name='PANTS']/@Value", resource, XPathConstants.STRING);
            Assert.assertNotNull((Object)Integer.valueOf(value));
        }
    }

    @Test
    public void testDefaultXmlCollector() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "Namespace");
        parameters.put("handler-class", "org.opennms.protocols.xml.collector.MockDefaultXmlCollectionHandler");
        this.executeCollectorTest(parameters, 1);
        Assert.assertTrue((boolean)new File(this.getSnmpRootDirectory(), "1/namespace-stats.jrb").exists());
        File file = new File(this.getSnmpRootDirectory(), "1/namespace-stats.jrb");
        String[] dsnames = new String[]{"requests", "responses", "errors", "warnings", "hats", "pants"};
        Double[] dsvalues = new Double[]{13.0, 12.0, 1.0, 2.0, 3.0, 4.0};
        this.validateJrb(file, dsnames, dsvalues);
    }
}

