/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.opennms.core.collection.test.MockCollectionAgent;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersisterFactory;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.protocols.xml.collector.MockDocumentBuilder;
import org.opennms.protocols.xml.collector.XmlCollector;
import org.opennms.protocols.xml.collector.XmlCollectorTestUtils;
import org.opennms.protocols.xml.config.XmlRrd;
import org.opennms.protocols.xml.dao.XmlDataCollectionConfigDao;
import org.opennms.protocols.xml.dao.jaxb.XmlDataCollectionConfigDaoJaxb;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class XmlCollectorITCase {
    @Rule
    public TemporaryFolder m_temporaryFolder = new TemporaryFolder();
    private CollectionAgent m_collectionAgent;
    private EventProxy m_eventProxy;
    private XmlDataCollectionConfigDaoJaxb m_xmlCollectionDao;
    private RrdStrategy<?, ?> m_rrdStrategy;
    private FilesystemResourceStorageDao m_resourceStorageDao;
    private RrdPersisterFactory m_persisterFactory;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.initializeRrdStrategy();
        this.initializeDocumentBuilder();
        this.m_collectionAgent = new MockCollectionAgent(1, "mynode.local", InetAddrUtils.addr((String)"127.0.0.1"));
        this.m_eventProxy = (EventProxy)EasyMock.createMock(EventProxy.class);
        this.m_xmlCollectionDao = new XmlDataCollectionConfigDaoJaxb();
        FileSystemResource resource = new FileSystemResource(this.getConfigFileName());
        this.m_xmlCollectionDao.setConfigResource((Resource)resource);
        this.m_xmlCollectionDao.afterPropertiesSet();
        EasyMock.replay((Object[])new Object[]{this.m_eventProxy});
    }

    protected void initializeDocumentBuilder() {
        MockDocumentBuilder.setXmlFileName(this.getSampleFileName());
    }

    protected void initializeRrdStrategy() throws Exception {
        this.m_rrdStrategy = new JRobinRrdStrategy();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        this.m_resourceStorageDao.setRrdDirectory(this.m_temporaryFolder.getRoot());
        this.m_temporaryFolder.newFolder("snmp");
        this.m_persisterFactory = new RrdPersisterFactory();
        this.m_persisterFactory.setResourceStorageDao((ResourceStorageDao)this.m_resourceStorageDao);
        this.m_persisterFactory.setRrdStrategy(this.m_rrdStrategy);
    }

    protected RrdStrategy<?, ?> getRrdStrategy() throws Exception {
        return this.m_rrdStrategy;
    }

    protected String getRrdExtension() {
        return this.m_rrdStrategy.getDefaultFileExtension().substring(1);
    }

    public XmlDataCollectionConfigDaoJaxb getConfigDao() {
        return this.m_xmlCollectionDao;
    }

    public abstract String getSampleFileName();

    public abstract String getConfigFileName();

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.m_eventProxy});
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public CollectionSet executeCollectorTest(Map<String, Object> parameters, int expectedFiles) throws Exception {
        XmlCollector collector = new XmlCollector();
        collector.setXmlCollectionDao((XmlDataCollectionConfigDao)this.m_xmlCollectionDao);
        CollectionSet collectionSet = XmlCollectorTestUtils.doCollect(collector, this.m_collectionAgent, parameters);
        Assert.assertEquals((Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        ServiceParameters serviceParams = new ServiceParameters(new HashMap());
        Persister persister = this.m_persisterFactory.createGroupPersister(serviceParams, this.createRrdRepository((String)parameters.get("collection")), false, false);
        collectionSet.visit((CollectionSetVisitor)persister);
        Assert.assertEquals((long)expectedFiles, (long)FileUtils.listFiles((File)this.getSnmpRootDirectory(), (String[])new String[]{this.getRrdExtension()}, (boolean)true).size());
        return collectionSet;
    }

    public void validateJrb(File file, String[] dsnames, Double[] dsvalues) throws Exception {
        Assert.assertTrue((boolean)file.exists());
        RrdDb jrb = new RrdDb(file);
        Assert.assertEquals((long)dsnames.length, (long)jrb.getDsCount());
        for (int i = 0; i < dsnames.length; ++i) {
            Datasource ds = jrb.getDatasource(dsnames[i]);
            Assert.assertNotNull((Object)ds);
            Assert.assertEquals((Object)dsvalues[i], (Object)ds.getLastValue());
        }
    }

    private RrdRepository createRrdRepository(String collection) throws IOException {
        XmlRrd rrd = this.m_xmlCollectionDao.getDataCollectionByName(collection).getXmlRrd();
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRootDirectory());
        repository.setHeartBeat(rrd.getStep() * 2);
        repository.setStep(rrd.getStep().intValue());
        repository.setRraList(rrd.getXmlRras());
        return repository;
    }

    public File getSnmpRootDirectory() {
        return new File(this.m_temporaryFolder.getRoot(), "snmp");
    }
}

