/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.mockito.Mockito;
import org.opennms.netmgt.collection.test.api.CollectorComplianceTest;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.xml.collector.XmlCollector;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlDataCollectionConfig;
import org.opennms.protocols.xml.config.XmlRrd;
import org.opennms.protocols.xml.dao.XmlDataCollectionConfigDao;

public class XmlCollectorComplianceTest
extends CollectorComplianceTest {
    private static final String COLLECTION = "default";

    public XmlCollectorComplianceTest() {
        super(XmlCollector.class, true);
    }

    public String getCollectionName() {
        return COLLECTION;
    }

    public Map<String, Object> getRequiredParameters() {
        return new ImmutableMap.Builder().put((Object)"collection", (Object)COLLECTION).build();
    }

    public Map<String, Object> getRequiredBeans() {
        XmlDataCollectionConfig config = (XmlDataCollectionConfig)Mockito.mock(XmlDataCollectionConfig.class);
        Mockito.when((Object)config.getRrdRepository()).thenReturn((Object)"target");
        Mockito.when((Object)config.buildRrdRepository(COLLECTION)).thenReturn((Object)new RrdRepository());
        XmlRrd xmlRrd = new XmlRrd();
        xmlRrd.setStep(Integer.valueOf(300));
        XmlDataCollection collection = new XmlDataCollection();
        collection.setXmlRrd(xmlRrd);
        XmlDataCollectionConfigDao xmlDataCollectionConfigDao = (XmlDataCollectionConfigDao)Mockito.mock(XmlDataCollectionConfigDao.class);
        Mockito.when((Object)xmlDataCollectionConfigDao.getDataCollectionByName(COLLECTION)).thenReturn((Object)collection);
        Mockito.when((Object)xmlDataCollectionConfigDao.getConfig()).thenReturn((Object)config);
        return new ImmutableMap.Builder().put((Object)"xmlDataCollectionConfigDao", (Object)xmlDataCollectionConfigDao).build();
    }
}

