/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.protocols.xml.collector.MockDefaultXmlCollectionHandler;
import org.opennms.protocols.xml.collector.MockDocumentBuilder;
import org.opennms.protocols.xml.collector.XmlCollectorITCase;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlSource;

public class XmlCollector3GPPIT
extends XmlCollectorITCase {
    @Override
    public String getConfigFileName() {
        return "src/test/resources/3gpp-xml-datacollection-config.xml";
    }

    @Override
    public String getSampleFileName() {
        return "src/test/resources/A20111025.0030-0500-0045-0500_MME00001.xml";
    }

    @Test
    public void testTimeParser() throws Exception {
        String pattern = "yyyy-MM-dd'T'HH:mm:ssZ";
        String value = "2011-10-25T00:45:00-05:00";
        long expectedTimestamp = 1319521500000L;
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern);
        DateTime dateTime = dtf.parseDateTime(value);
        Date date = dateTime.toDate();
        Assert.assertEquals((long)expectedTimestamp, (long)date.getTime());
        MockDefaultXmlCollectionHandler handler = new MockDefaultXmlCollectionHandler();
        XPath xpath = XPathFactory.newInstance().newXPath();
        date = handler.getTimeStamp(MockDocumentBuilder.getXmlDocument(), xpath, (XmlGroup)((XmlSource)this.getConfigDao().getDataCollectionByName("3GPP").getXmlSources().get(0)).getXmlGroups().get(0));
        Assert.assertEquals((long)expectedTimestamp, (long)date.getTime());
    }

    @Test
    public void testDefaultXmlCollector() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "3GPP");
        parameters.put("handler-class", "org.opennms.protocols.xml.collector.MockDefaultXmlCollectionHandler");
        this.executeCollectorTest(parameters, 147);
        File file = new File(this.getSnmpRootDirectory(), "1/platformSystemResource/processor_v1_frame0_shelf0_slot4_sub-slot1/platform-system-resource.jrb");
        String[] dsnames = new String[]{"cpuUtilization", "memoryUtilization"};
        Double[] dsvalues = new Double[]{1.0, 18.0};
        this.validateJrb(file, dsnames, dsvalues);
    }
}

