/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import java.io.File;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.opennms.core.test.xml.XmlTestNoCastor;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlDataCollectionConfig;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlRrd;
import org.opennms.protocols.xml.config.XmlSource;

public class XmlDataCollectionConfigTest
extends XmlTestNoCastor<XmlDataCollectionConfig> {
    private final XmlDataCollectionConfig sampleObject;

    public XmlDataCollectionConfigTest(XmlDataCollectionConfig sampleObject, Object sampleXml, String schemaFile) {
        super((Object)sampleObject, sampleXml, schemaFile);
        this.sampleObject = sampleObject;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws ParseException {
        return Arrays.asList(new Object[][]{{XmlDataCollectionConfigTest.getXmlDataCollectionConfig(), new File("src/test/resources/", "xml-datacollection-config.xml"), "src/main/resources/xsds/xml-datacollection-config.xsd"}});
    }

    @Test
    public void canClone() {
        XmlDataCollectionConfig clone = this.sampleObject.clone();
        Assert.assertEquals((Object)this.sampleObject, (Object)clone);
    }

    public static XmlDataCollectionConfig getXmlDataCollectionConfig() {
        XmlRrd xmlRrd = new XmlRrd();
        xmlRrd.addRra("RRA:AVERAGE:0.5:1:8928");
        xmlRrd.addRra("RRA:AVERAGE:0.5:12:8784");
        xmlRrd.addRra("RRA:MIN:0.5:12:8784");
        xmlRrd.addRra("RRA:MAX:0.5:12:8784");
        xmlRrd.setStep(Integer.valueOf(300));
        XmlObject cpu = new XmlObject();
        cpu.setName("cpuUtilization");
        cpu.setDataType(AttributeType.GAUGE);
        cpu.setXpath("r[@p=1]");
        XmlObject mem = new XmlObject();
        mem.setName("memUtilization");
        mem.setDataType(AttributeType.GAUGE);
        mem.setXpath("r[@p=2]");
        XmlObject suspect = new XmlObject();
        suspect.setName("suspect");
        suspect.setDataType(AttributeType.STRING);
        suspect.setXpath("suspect");
        XmlGroup group = new XmlGroup();
        group.setName("platform-system-resource");
        group.setResourceType("platformSystemResource");
        group.setResourceXpath("/measCollecFile/measData/measInfo[@measInfoId='platform-system|resource']/measValue");
        group.setKeyXpath("@measObjLdn");
        group.setTimestampXpath("/measCollecFile/fileFooter/measCollec/@endTime");
        group.setTimestampFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        group.addXmlObject(cpu);
        group.addXmlObject(mem);
        group.addXmlObject(suspect);
        XmlSource source = new XmlSource();
        source.setUrl("sftp.3gpp://opennms:Op3nNMS!@{ipaddr}/opt/3gpp/data/?step={step}&neId={foreignId}");
        source.addXmlGroup(group);
        XmlDataCollection xmlDataCollection = new XmlDataCollection();
        xmlDataCollection.setXmlRrd(xmlRrd);
        xmlDataCollection.addXmlSource(source);
        xmlDataCollection.setName("3GPP");
        XmlDataCollectionConfig xmlDataCollectionConfig = new XmlDataCollectionConfig();
        xmlDataCollectionConfig.setRrdRepository("/opt/opennms/share/rrd/snmp/");
        xmlDataCollectionConfig.addDataCollection(xmlDataCollection);
        return xmlDataCollectionConfig;
    }
}

