/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;

public class AbstractXmlCollectionHandlerTest {
    @Test
    public void testParseString() throws Exception {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("mynode.local");
        OnmsAssetRecord asset = new OnmsAssetRecord();
        asset.setSerialNumber("1001");
        node.setAssetRecord(asset);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("port", "80");
        String url = AbstractXmlCollectionHandler.parseString((String)"URL", (String)"http://{nodeLabel}:{parameter:port}/{ipAddress}/serial/{serialNumber}/{step}", (OnmsNode)node, (String)"127.0.0.1", (Integer)300, parameters);
        Assert.assertEquals((Object)"http://mynode.local:80/127.0.0.1/serial/1001/300", (Object)url);
        String multiline = "<data>\n   <source label='{nodeLabel}'/>\n</data>";
        String xml = AbstractXmlCollectionHandler.parseString((String)"Content", (String)multiline, (OnmsNode)node, (String)"127.0.0.1", (Integer)300, parameters);
        Assert.assertEquals((Object)"<data>\n   <source label='mynode.local'/>\n</data>", (Object)xml);
    }
}

