/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.protocols.xml.config.Request;

public class RequestTest {
    @Test
    public void shouldResolveGetParameter() {
        Request request = new Request();
        request.addParameter("null value", null);
        request.addParameter("string value", "string");
        TestCase.assertNull((Object)request.getParameter("null value"));
        TestCase.assertEquals((String)"string", (String)request.getParameter("string value"));
        TestCase.assertNull((Object)request.getParameter("not present value"));
    }

    @Test
    public void shouldResolveGetParameterAsInt() {
        Request request = new Request();
        request.addParameter("null value", null);
        request.addParameter("int value", "3");
        request.addParameter("not valid int value", "blah");
        TestCase.assertEquals((int)-1, (int)request.getParameterAsInt("null value"));
        TestCase.assertEquals((int)3, (int)request.getParameterAsInt("int value"));
        TestCase.assertEquals((int)-1, (int)request.getParameterAsInt("not valid int value"));
        TestCase.assertEquals((int)-1, (int)request.getParameterAsInt("not present value"));
    }

    @Test
    public void shouldResolveGetParameterAsBoolean() {
        Request request = new Request();
        request.addParameter("null value", null);
        request.addParameter("true", "true");
        request.addParameter("false", "false");
        request.addParameter("not alid boolean value", "blah");
        Assert.assertFalse((boolean)request.getParameterAsBoolean("null value"));
        Assert.assertTrue((boolean)request.getParameterAsBoolean("true"));
        Assert.assertFalse((boolean)request.getParameterAsBoolean("false"));
        Assert.assertFalse((boolean)request.getParameterAsBoolean("not valid boolean value"));
        Assert.assertFalse((boolean)request.getParameterAsBoolean("not present value"));
    }
}

