/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ResourceTypeMapper;
import org.opennms.netmgt.collection.support.PersistAllSelectorStrategy;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.protocols.xml.collector.XmlCollectionHandler;
import org.opennms.protocols.xml.collector.XmlCollector;
import org.opennms.protocols.xml.collector.XmlStorageStrategy;
import org.opennms.protocols.xml.config.XmlDataCollection;

public class XmlCollectorTestUtils {
    public static CollectionSet doCollect(XmlCollector collector, CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        ResourceTypeMapper.getInstance().setResourceTypeMapper(type -> XmlCollectorTestUtils.getResourceType(type));
        Map runtimeAttributes = collector.getRuntimeAttributes(agent, parameters);
        Map<String, Object> allParams = new HashMap<String, Object>();
        allParams.putAll(parameters);
        allParams.putAll(runtimeAttributes);
        allParams = Collections.unmodifiableMap(allParams);
        return collector.collect(agent, allParams);
    }

    public static CollectionSet doCollect(NodeDao nodeDao, XmlCollectionHandler handler, CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
        ResourceTypeMapper.getInstance().setResourceTypeMapper(type -> XmlCollectorTestUtils.getResourceType(type));
        XmlCollector collector = new XmlCollector();
        collector.setNodeDao(nodeDao);
        XmlDataCollection parsedCollection = collector.parseCollection(collection, handler, agent, parameters);
        return handler.collect(agent, parsedCollection, parameters);
    }

    public static ResourceType getResourceType(String resourceType) {
        ResourceType rt = new ResourceType();
        rt.setName(resourceType);
        rt.setStorageStrategy(new StorageStrategy());
        rt.getStorageStrategy().setClazz(XmlStorageStrategy.class.getName());
        rt.setPersistenceSelectorStrategy(new PersistenceSelectorStrategy());
        rt.getPersistenceSelectorStrategy().setClazz(PersistAllSelectorStrategy.class.getName());
        return rt;
    }
}

