/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.sftp;

import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.protocols.sftp.Sftp3gppUrlConnection;
import org.opennms.protocols.sftp.SftpUrlConnection;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sftp3gppUrlConnectionTest {
    private static final Logger LOG = LoggerFactory.getLogger(Sftp3gppUrlConnectionTest.class);

    @Test
    public void testPathForSFTP() throws Exception {
        URL url = UrlFactory.getUrl((String)"sftp://admin:admin@192.168.1.1/opt/hitachi/cnp/data/pm/reports/3gpp/5/data.xml", null);
        URLConnection conn = url.openConnection();
        Assert.assertTrue((boolean)(conn instanceof SftpUrlConnection));
        UrlFactory.disconnect((URLConnection)conn);
    }

    @Test
    public void testPathFor3GPPA() throws Exception {
        URL url = UrlFactory.getUrl((String)"sftp.3gpp://admin:admin@192.168.1.1/opt/hitachi/cnp/data/pm/reports/3gpp/5?step=300&timezone=GMT-5&neId=MME00001", null);
        URLConnection conn = url.openConnection();
        Assert.assertTrue((boolean)(conn instanceof Sftp3gppUrlConnection));
        String path = ((Sftp3gppUrlConnection)conn).getPath();
        LOG.debug(path);
        UrlFactory.disconnect((URLConnection)conn);
    }

    @Test
    public void testCustomPathFor3GPPA() throws Exception {
        long ts = 1320257100000L;
        Date date = new Date(ts);
        LOG.debug("Timestamp = {}", (Object)date);
        URL url = UrlFactory.getUrl((String)("sftp.3gpp://admin:admin@192.168.1.1/opt/3gpp?step=300&timezone=GMT-5&neId=MME00001&referenceTimestamp=" + ts), null);
        URLConnection conn = url.openConnection();
        Assert.assertTrue((boolean)(conn instanceof Sftp3gppUrlConnection));
        String path = ((Sftp3gppUrlConnection)conn).getPath();
        LOG.debug(path);
        UrlFactory.disconnect((URLConnection)conn);
        Assert.assertEquals((Object)"/opt/3gpp/A20111102.1300-0500-1305-0500_MME00001", (Object)path);
    }

    @Test
    public void testGetTimeStampFromFile() throws Exception {
        URL url = UrlFactory.getUrl((String)"sftp.3gpp://admin:admin@192.168.1.1/opt/3gpp?step=300&neId=MME00001&deleteFile=true", null);
        URLConnection conn = url.openConnection();
        Assert.assertTrue((boolean)(conn instanceof Sftp3gppUrlConnection));
        Sftp3gppUrlConnection c = (Sftp3gppUrlConnection)conn;
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)c.getQueryMap().get("deletefile")));
        long t1 = c.getTimeStampFromFile("A20111102.1300-0500-1305-0500_MME00001");
        long t2 = c.getTimeStampFromFile("A20111102.1305-0500-1310-0500_MME00001");
        Assert.assertTrue((t2 > t1 ? 1 : 0) != 0);
        Assert.assertTrue((t2 - t1 == Long.parseLong((String)c.getQueryMap().get("step")) * 1000L ? 1 : 0) != 0);
    }
}

