/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.easymock.EasyMock;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.opennms.core.collection.test.CollectionSetUtils;
import org.opennms.core.collection.test.MockCollectionAgent;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.http.JUnitHttpServerExecutionListener;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.test.http.annotations.Webapp;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersisterFactory;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DefaultDataCollectionConfigDao;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.protocols.http.collector.HttpCollectionHandler;
import org.opennms.protocols.json.collector.DefaultJsonCollectionHandler;
import org.opennms.protocols.xml.collector.DefaultXmlCollectionHandler;
import org.opennms.protocols.xml.collector.XmlCollectionHandler;
import org.opennms.protocols.xml.collector.XmlCollectorTestUtils;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlDataCollectionConfig;
import org.opennms.protocols.xml.config.XmlRrd;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={JUnitHttpServerExecutionListener.class})
public class HttpDataCollectionIT {
    @Rule
    public TemporaryFolder m_temporaryFolder = new TemporaryFolder();
    private CollectionAgent m_collectionAgent;
    private NodeDao m_nodeDao;
    private RrdStrategy<?, ?> m_rrdStrategy;
    private FilesystemResourceStorageDao m_resourceStorageDao;
    private RrdPersisterFactory m_persisterFactory;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        DefaultDataCollectionConfigDao dao = new DefaultDataCollectionConfigDao();
        dao.setConfigDirectory("src/test/resources/etc/datacollection");
        dao.setConfigResource((Resource)new FileSystemResource("src/test/resources/etc/datacollection-config.xml"));
        dao.afterPropertiesSet();
        DataCollectionConfigFactory.setInstance((DataCollectionConfigDao)dao);
        this.m_rrdStrategy = new JRobinRrdStrategy();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        this.m_resourceStorageDao.setRrdDirectory(this.m_temporaryFolder.getRoot());
        this.m_temporaryFolder.newFolder("snmp");
        this.m_persisterFactory = new RrdPersisterFactory();
        this.m_persisterFactory.setResourceStorageDao((ResourceStorageDao)this.m_resourceStorageDao);
        this.m_persisterFactory.setRrdStrategy(this.m_rrdStrategy);
        this.m_collectionAgent = new MockCollectionAgent(1, "mynode.local", InetAddrUtils.addr((String)"127.0.0.1"));
        this.m_nodeDao = (NodeDao)EasyMock.createMock(NodeDao.class);
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("mynode.local");
        node.setAssetRecord(new OnmsAssetRecord());
        EasyMock.expect((Object)this.m_nodeDao.get((Serializable)Integer.valueOf(1))).andReturn((Object)node).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.m_nodeDao});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.m_nodeDao});
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    @JUnitHttpServer(port=10342, https=false, webapps={@Webapp(context="/junit", path="src/test/resources/test-webapp")})
    public void testHttpCollection() throws Exception {
        File configFile = new File("src/test/resources/http-datacollection-config.xml");
        XmlDataCollectionConfig config = (XmlDataCollectionConfig)JaxbUtils.unmarshal(XmlDataCollectionConfig.class, (File)configFile);
        XmlDataCollection collection = config.getDataCollectionByName("Http-Count");
        RrdRepository repository = this.createRrdRepository(collection.getXmlRrd());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "Http-Count");
        DefaultXmlCollectionHandler collector = new DefaultXmlCollectionHandler();
        collector.setRrdRepository(repository);
        collector.setServiceName("HTTP");
        CollectionSet collectionSet = XmlCollectorTestUtils.doCollect(this.m_nodeDao, (XmlCollectionHandler)collector, this.m_collectionAgent, collection, parameters);
        Assert.assertEquals((Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        ServiceParameters serviceParams = new ServiceParameters(new HashMap());
        Persister persister = this.m_persisterFactory.createGroupPersister(serviceParams, repository, false, false);
        collectionSet.visit((CollectionSetVisitor)persister);
        RrdDb jrb = new RrdDb(new File(this.getSnmpRoot(), "1/count-stats.jrb"));
        Assert.assertNotNull((Object)jrb);
        Assert.assertEquals((long)1L, (long)jrb.getDsCount());
        Datasource ds = jrb.getDatasource("count");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((Object)new Double(5.0), (Object)ds.getLastValue());
    }

    @Test
    @JUnitHttpServer(port=10342, https=false, webapps={@Webapp(context="/junit", path="src/test/resources/test-webapp")})
    public void testCssSelectorHttpCollection() throws Exception {
        File configFile = new File("src/test/resources/http-datacollection-config.xml");
        XmlDataCollectionConfig config = (XmlDataCollectionConfig)JaxbUtils.unmarshal(XmlDataCollectionConfig.class, (File)configFile);
        XmlDataCollection collection = config.getDataCollectionByName("Http-Market");
        RrdRepository repository = this.createRrdRepository(collection.getXmlRrd());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "Http-Market");
        HttpCollectionHandler collector = new HttpCollectionHandler();
        collector.setRrdRepository(repository);
        collector.setServiceName("HTTP");
        CollectionSet collectionSet = XmlCollectorTestUtils.doCollect(this.m_nodeDao, (XmlCollectionHandler)collector, this.m_collectionAgent, collection, parameters);
        Assert.assertEquals((Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        ServiceParameters serviceParams = new ServiceParameters(new HashMap());
        Persister persister = this.m_persisterFactory.createGroupPersister(serviceParams, repository, false, false);
        collectionSet.visit((CollectionSetVisitor)persister);
        RrdDb jrb = new RrdDb(new File(this.getSnmpRoot(), "1/market.jrb"));
        Assert.assertNotNull((Object)jrb);
        Assert.assertEquals((long)2L, (long)jrb.getDsCount());
        Datasource ds = jrb.getDatasource("nasdaq");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((Object)new Double(3578.3), (Object)ds.getLastValue());
    }

    @Test
    @JUnitHttpServer(port=10342, https=false, webapps={@Webapp(context="/junit", path="src/test/resources/test-webapp")})
    public void testPostRequestHttpCollection() throws Exception {
        File configFile = new File("src/test/resources/http-datacollection-config.xml");
        XmlDataCollectionConfig config = (XmlDataCollectionConfig)JaxbUtils.unmarshal(XmlDataCollectionConfig.class, (File)configFile);
        XmlDataCollection collection = config.getDataCollectionByName("Http-Person-Stats");
        RrdRepository repository = this.createRrdRepository(collection.getXmlRrd());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "Http-Person-Stats");
        DefaultXmlCollectionHandler collector = new DefaultXmlCollectionHandler();
        collector.setRrdRepository(repository);
        collector.setServiceName("HTTP");
        CollectionSet collectionSet = XmlCollectorTestUtils.doCollect(this.m_nodeDao, (XmlCollectionHandler)collector, this.m_collectionAgent, collection, parameters);
        Assert.assertEquals((Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        ServiceParameters serviceParams = new ServiceParameters(new HashMap());
        Persister persister = this.m_persisterFactory.createGroupPersister(serviceParams, repository, false, false);
        collectionSet.visit((CollectionSetVisitor)persister);
        RrdDb jrb = new RrdDb(new File(this.getSnmpRoot(), "1/person-stats.jrb"));
        Assert.assertNotNull((Object)jrb);
        Assert.assertEquals((long)3L, (long)jrb.getDsCount());
        Datasource ds = jrb.getDatasource("contributions");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((Object)new Double(500.0), (Object)ds.getLastValue());
    }

    @Test
    @JUnitHttpServer(port=10342, https=false, webapps={@Webapp(context="/junit", path="src/test/resources/test-webapp")})
    public void testJsonHttpCollection() throws Exception {
        File configFile = new File("src/test/resources/solaris-zones-datacollection-config.xml");
        XmlDataCollectionConfig config = (XmlDataCollectionConfig)JaxbUtils.unmarshal(XmlDataCollectionConfig.class, (File)configFile);
        XmlDataCollection collection = config.getDataCollectionByName("Solaris");
        RrdRepository repository = this.createRrdRepository(collection.getXmlRrd());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "Solaris");
        DefaultJsonCollectionHandler collector = new DefaultJsonCollectionHandler();
        collector.setRrdRepository(repository);
        collector.setServiceName("HTTP");
        CollectionSet collectionSet = XmlCollectorTestUtils.doCollect(this.m_nodeDao, (XmlCollectionHandler)collector, this.m_collectionAgent, collection, parameters);
        Assert.assertEquals((Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
        System.err.println(CollectionSetUtils.flatten((CollectionSet)collectionSet));
        ServiceParameters serviceParams = new ServiceParameters(new HashMap());
        Persister persister = this.m_persisterFactory.createGroupPersister(serviceParams, repository, false, false);
        collectionSet.visit((CollectionSetVisitor)persister);
        RrdDb jrb = new RrdDb(new File(this.getSnmpRoot(), "1/solarisZoneStats/global/solaris-zone-stats.jrb"));
        Assert.assertNotNull((Object)jrb);
        Assert.assertEquals((long)6L, (long)jrb.getDsCount());
        Datasource ds = jrb.getDatasource("nproc");
        Assert.assertNotNull((Object)ds);
        Assert.assertEquals((Object)new Double(245.0), (Object)ds.getLastValue());
    }

    private RrdRepository createRrdRepository(XmlRrd rrd) throws IOException {
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRoot());
        repository.setHeartBeat(rrd.getStep() * 2);
        repository.setStep(rrd.getStep().intValue());
        repository.setRraList(rrd.getXmlRras());
        return repository;
    }

    public File getSnmpRoot() {
        return new File(this.m_temporaryFolder.getRoot(), "snmp");
    }
}

