/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlResourceType;

public class XmlMultiInstanceCollectionResource
extends XmlCollectionResource {
    private final String m_instance;
    private String m_resourceLabel;
    private final XmlResourceType m_resourceType;

    public XmlMultiInstanceCollectionResource(CollectionAgent agent, String instance, XmlResourceType type) {
        super(agent);
        this.m_resourceType = type;
        this.m_instance = instance;
    }

    public boolean shouldPersist(ServiceParameters params) {
        return this.m_resourceType.getPersistenceSelectorStrategy().shouldPersist((CollectionResource)this);
    }

    public ResourcePath getPath() {
        return this.m_resourceType.getStorageStrategy().getRelativePathForAttribute(this.getParent(), this.getInterfaceLabel());
    }

    @Override
    public String getResourceTypeName() {
        return this.m_resourceType.getName();
    }

    @Override
    public String getInstance() {
        return this.m_instance;
    }

    public String toString() {
        return "node[" + this.m_agent.getNodeId() + "]." + this.getResourceTypeName() + "[" + this.getInterfaceLabel() + "]";
    }

    public String getInterfaceLabel() {
        if (this.m_resourceLabel == null) {
            this.m_resourceLabel = this.m_resourceType.getStorageStrategy().getResourceNameFromIndex((CollectionResource)this);
        }
        return this.m_resourceLabel;
    }
}

