/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlCollectionAttribute
extends AbstractCollectionAttribute {
    private static final Logger LOG = LoggerFactory.getLogger(XmlCollectionAttribute.class);
    private final String m_value;

    public XmlCollectionAttribute(XmlCollectionResource resource, XmlCollectionAttributeType attribType, String value) {
        super((CollectionAttributeType)attribType, (CollectionResource)resource);
        this.m_value = value;
    }

    public Number getNumericValue() {
        try {
            return this.parseNumber(this.m_value);
        }
        catch (Exception e) {
            LOG.debug("getNumericValue: the value '{}' is not a valid number. Removing invalid characters and try again.", (Object)this.m_value);
            try {
                return this.parseNumber(this.m_value.replaceAll("[^-\\d.]+", ""));
            }
            catch (Exception ex) {
                LOG.warn("getNumericValue: the value '{}' is not parsable as a valid numeric value.", (Object)this.m_value);
                return Double.NaN;
            }
        }
    }

    private Number parseNumber(String number) throws Exception {
        Double d = Double.parseDouble(number);
        if (AttributeType.COUNTER.equals((Object)this.getType())) {
            return d.longValue();
        }
        return d;
    }

    public String getStringValue() {
        return this.m_value;
    }

    public String toString() {
        return "XmlCollectionAttribute(" + this.getName() + "=" + this.getStringValue() + ")@" + this.getResource();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XmlCollectionAttribute) {
            XmlCollectionAttribute attr = (XmlCollectionAttribute)((Object)obj);
            return this.getResource().equals(attr.getResource()) && this.getAttributeType().equals((Object)attr.getAttributeType());
        }
        return false;
    }

    public int hashCode() {
        return this.getResource().hashCode() ^ this.getAttributeType().hashCode();
    }

    public String getMetricIdentifier() {
        return "Not supported yet._XML_" + this.getName();
    }
}

