/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.protocols.sftp.Sftp3gppUrlConnection;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.config.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Sftp3gppUtils {
    private static final Logger LOG = LoggerFactory.getLogger(Sftp3gppUtils.class);
    public static final String PM_GROUPS_FILENAME = "3gpp-pmgroups.properties";
    public static final String XML_LAST_FILENAME = "_xmlCollectorLastFilename";
    private static final Properties m_pmGroups = new Properties();

    public static String getLastFilename(ResourceStorageDao resourceStorageDao, String serviceName, ResourcePath path, String targetPath) throws Exception {
        String filename = null;
        try {
            filename = resourceStorageDao.getStringAttribute(path, Sftp3gppUtils.getCacheId(serviceName, targetPath));
        }
        catch (Throwable e) {
            LOG.info("getLastFilename: creating a new filename tracker on {}", (Object)path);
        }
        return filename;
    }

    public static void setLastFilename(ResourceStorageDao resourceStorageDao, String serviceName, ResourcePath path, String targetPath, String filename) throws Exception {
        resourceStorageDao.setStringAttribute(path, Sftp3gppUtils.getCacheId(serviceName, targetPath), filename);
    }

    public static String getCacheId(String serviceName, String targetPath) {
        return "_xmlCollectorLastFilename." + serviceName + targetPath.replaceAll("/", "_");
    }

    public static void deleteFile(Sftp3gppUrlConnection connection, String fileName) {
        try {
            connection.deleteFile(fileName);
        }
        catch (Exception e) {
            LOG.warn("Can't delete file {} from {} because {}", new Object[]{fileName, connection.getURL().getHost(), e.getMessage()});
        }
    }

    public static void processXmlResource(XmlCollectionResource resource, AttributeGroupType attribGroupType) {
        Map<String, String> properties = Sftp3gppUtils.get3gppProperties(Sftp3gppUtils.get3gppFormat(resource.getResourceTypeName()), resource.getInstance());
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            XmlCollectionAttributeType attribType = new XmlCollectionAttributeType(new XmlObject(entry.getKey(), AttributeType.STRING), attribGroupType);
            resource.setAttributeValue(attribType, entry.getValue());
        }
    }

    public static String get3gppFormat(String resourceType) {
        if (m_pmGroups.isEmpty()) {
            try {
                File configFile = new File(ConfigFileConstants.getFilePathString(), PM_GROUPS_FILENAME);
                if (configFile.exists()) {
                    LOG.info("Using 3GPP PM Groups format from {}", (Object)configFile);
                    m_pmGroups.load(new FileInputStream(configFile));
                } else {
                    LOG.info("Using default 3GPP PM Groups format.");
                    m_pmGroups.load(Sftp3gppUtils.class.getResourceAsStream("/3gpp-pmgroups.properties"));
                }
            }
            catch (Exception e) {
                LOG.warn("Can't load 3GPP PM Groups format because {}", (Object)e.getMessage());
            }
        }
        return m_pmGroups.getProperty(resourceType);
    }

    public static Map<String, String> get3gppProperties(String format, String measInfoId) {
        String[] groups;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (format != null) {
            for (String group : groups = format.split("\\|")) {
                String[] subgroups;
                for (String subgroup : subgroups = group.split("/")) {
                    String[] pair = subgroup.split("=");
                    if (pair.length <= 1 || !pair[1].matches("^[<].+[>]$")) continue;
                    String valueRegex = pair[1].equals("<directory path>") ? "=([^|]+)" : "=([^|/]+)";
                    Matcher m = Pattern.compile(pair[0] + valueRegex).matcher(measInfoId);
                    if (!m.find()) continue;
                    String v = pair[1].equals("<directory path>") ? m.group(1).replaceAll("\\\\/", "/") : m.group(1);
                    properties.put(pair[0], v);
                }
            }
        }
        if (properties.isEmpty() && Boolean.getBoolean("org.opennms.collectd.xml.3gpp.useSimpleParserForMeasObjLdn")) {
            for (String group : groups = measInfoId.split("\\|")) {
                String[] pair = group.split("=");
                if (pair.length != 2) continue;
                properties.put(pair[0], pair[1]);
            }
        }
        properties.put("label", properties.isEmpty() ? measInfoId : ((Object)properties).toString().replaceAll("[{}]", ""));
        properties.put("instance", measInfoId);
        return properties;
    }
}

