/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlDataCollectionConfig;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlRrd;
import org.opennms.protocols.xml.config.XmlSource;
import org.opennms.test.FileAnticipator;
import org.xml.sax.SAXException;

public class XmlDataCollectionConfigTest {
    private FileAnticipator fileAnticipator;
    private XmlDataCollectionConfig xmldcc;

    @Before
    public void setUp() throws Exception {
        this.fileAnticipator = new FileAnticipator();
        XmlRrd xmlRrd = new XmlRrd();
        xmlRrd.addRra("RRA:AVERAGE:0.5:1:8928");
        xmlRrd.addRra("RRA:AVERAGE:0.5:12:8784");
        xmlRrd.addRra("RRA:MIN:0.5:12:8784");
        xmlRrd.addRra("RRA:MAX:0.5:12:8784");
        xmlRrd.setStep(Integer.valueOf(300));
        XmlObject cpu = new XmlObject();
        cpu.setName("cpuUtilization");
        cpu.setDataType("GAUGE");
        cpu.setXpath("r[@p=1]");
        XmlObject mem = new XmlObject();
        mem.setName("memUtilization");
        mem.setDataType("GAUGE");
        mem.setXpath("r[@p=2]");
        XmlObject suspect = new XmlObject();
        suspect.setName("suspect");
        suspect.setDataType("STRING");
        suspect.setXpath("suspect");
        XmlGroup group = new XmlGroup();
        group.setName("platform-system-resource");
        group.setResourceType("platformSystemResource");
        group.setResourceXpath("/measCollecFile/measData/measInfo[@measInfoId='platform-system|resource']/measValue");
        group.setKeyXpath("@measObjLdn");
        group.setTimestampXpath("/measCollecFile/fileFooter/measCollec/@endTime");
        group.setTimestampFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        group.addXmlObject(cpu);
        group.addXmlObject(mem);
        group.addXmlObject(suspect);
        XmlSource source = new XmlSource();
        source.setUrl("sftp.3gpp://opennms:Op3nNMS!@{ipaddr}/opt/3gpp/data/?step={step}&neId={foreignId}");
        source.addXmlGroup(group);
        XmlDataCollection xmlDataCollection = new XmlDataCollection();
        xmlDataCollection.setXmlRrd(xmlRrd);
        xmlDataCollection.addXmlSource(source);
        xmlDataCollection.setName("3GPP");
        this.xmldcc = new XmlDataCollectionConfig();
        this.xmldcc.addDataCollection(xmlDataCollection);
        this.xmldcc.setRrdRepository("/opt/opennms/share/rrd/snmp/");
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)true);
        XMLUnit.setNormalize((boolean)true);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void generateSchema() throws Exception {
        File schemaFile = this.fileAnticipator.expecting("xml-datacollection-config.xsd");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XmlDataCollectionConfig.class});
        context.generateSchema((SchemaOutputResolver)new TestOutputResolver(schemaFile));
        if (this.fileAnticipator.isInitialized()) {
            this.fileAnticipator.deleteExpected();
        }
    }

    @Test
    public void generateXML() throws Exception {
        StringWriter objectXML = new StringWriter();
        JaxbUtils.marshal((Object)this.xmldcc, (Writer)objectXML);
        StringBuffer exampleXML = new StringBuffer();
        File xmlCollectionConfig = this.getSourceFile();
        Assert.assertTrue((String)"xml-datacollection-config.xml is readable", (boolean)xmlCollectionConfig.canRead());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(xmlCollectionConfig), "UTF-8"));
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) break;
            exampleXML.append(line).append("\n");
        }
        reader.close();
        System.err.println("========================================================================");
        System.err.println("Object XML:");
        System.err.println("========================================================================");
        System.err.print(objectXML.toString());
        System.err.println("========================================================================");
        System.err.println("Example XML:");
        System.err.println("========================================================================");
        System.err.print(exampleXML.toString());
        DetailedDiff myDiff = this.getDiff(objectXML, exampleXML);
        Assert.assertEquals((String)"number of XMLUnit differences between the example XML and the mock object XML is 0", (long)0L, (long)myDiff.getAllDifferences().size());
    }

    @Test
    public void readXML() throws Exception {
        File xmlCollectionConfig = this.getSourceFile();
        Assert.assertTrue((String)"xml-datacollection-config.xml is readable", (boolean)xmlCollectionConfig.canRead());
        XmlDataCollectionConfig exampleXmldcc = (XmlDataCollectionConfig)JaxbUtils.unmarshal(XmlDataCollectionConfig.class, (File)xmlCollectionConfig);
        Assert.assertTrue((String)"Compare XML Data Collection Config objects.", (boolean)this.xmldcc.equals((Object)exampleXmldcc));
    }

    private File getSourceFile() {
        File xmlCollectionConfig = new File("src/test/resources/", "xml-datacollection-config.xml");
        System.err.println("Source File: " + xmlCollectionConfig.getAbsolutePath());
        return xmlCollectionConfig;
    }

    private DetailedDiff getDiff(StringWriter objectXML, StringBuffer exampleXML) throws SAXException, IOException {
        DetailedDiff myDiff = new DetailedDiff(XMLUnit.compareXML((String)exampleXML.toString(), (String)objectXML.toString()));
        List allDifferences = myDiff.getAllDifferences();
        if (allDifferences.size() > 0) {
            for (Difference d : allDifferences) {
                System.err.println(d);
            }
        }
        return myDiff;
    }

    private static class TestOutputResolver
    extends SchemaOutputResolver {
        private final File m_schemaFile;

        public TestOutputResolver(File schemaFile) {
            this.m_schemaFile = schemaFile;
        }

        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
            return new StreamResult(this.m_schemaFile);
        }
    }
}

