/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.xml.collector.XmlCollectionHandler;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.dao.XmlDataCollectionConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(XmlCollector.class);
    private XmlDataCollectionConfigDao m_xmlCollectionDao;
    private XmlCollectionHandler m_collectionHandler;

    public XmlDataCollectionConfigDao getXmlCollectionDao() {
        return this.m_xmlCollectionDao;
    }

    public void setXmlCollectionDao(XmlDataCollectionConfigDao xmlCollectionDao) {
        this.m_xmlCollectionDao = xmlCollectionDao;
    }

    public void initialize(Map<String, String> parameters) throws CollectionInitializationException {
        LOG.debug("initialize: initializing XML collector");
        try {
            Charset.forName("UTF-8");
        }
        catch (UnsupportedCharsetException e) {
            throw new CollectionInitializationException("Can't initialize charset UTF-8: " + e.getMessage());
        }
        if (this.m_xmlCollectionDao == null) {
            this.m_xmlCollectionDao = (XmlDataCollectionConfigDao)BeanUtils.getBean((String)"daoContext", (String)"xmlDataCollectionConfigDao", XmlDataCollectionConfigDao.class);
        }
        LOG.debug("initialize: Initializing RRD repo from XmlCollector...");
        File f = new File(this.m_xmlCollectionDao.getConfig().getRrdRepository());
        if (!f.isDirectory() && !f.mkdirs()) {
            throw new CollectionInitializationException("Unable to create RRD file repository.  Path doesn't already exist and could not make directory: " + this.m_xmlCollectionDao.getConfig().getRrdRepository());
        }
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        LOG.debug("initialize: initializing XML collection handling using {} for collection agent {}", parameters, (Object)agent);
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"SERVICE", (String)"XML");
        String handlerClass = ParameterMap.getKeyedString(parameters, (String)"handler-class", (String)"org.opennms.protocols.xml.collector.DefaultXmlCollectionHandler");
        try {
            LOG.debug("initialize: instantiating XML collection handler {}", (Object)handlerClass);
            Class<?> clazz = Class.forName(handlerClass);
            this.m_collectionHandler = (XmlCollectionHandler)clazz.newInstance();
            this.m_collectionHandler.setServiceName(serviceName);
        }
        catch (Exception e) {
            throw new CollectionInitializationException("Unable to instantiate XML Collection Handler " + handlerClass + " because: " + e.getMessage());
        }
    }

    public void release() {
        LOG.debug("release: realeasing XML collection");
    }

    public void release(CollectionAgent agent) {
        LOG.debug("release: realeasing XML collection for agent {}", (Object)agent);
    }

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) throws CollectionException {
        if (parameters == null) {
            throw new CollectionException("Null parameters is now allowed in XML Collector!");
        }
        try {
            String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(parameters, (String)"xml-collection", null);
            }
            if (collectionName == null) {
                throw new CollectionException("Parameter collection is required for the XML Collector!");
            }
            LOG.debug("collect: collecting XML data using collection {} for {}", (Object)collectionName, (Object)agent);
            XmlDataCollection collection = this.m_xmlCollectionDao.getDataCollectionByName(collectionName);
            if (collection == null) {
                throw new CollectionException("XML Collection " + collectionName + " does not exist.");
            }
            this.m_collectionHandler.setRrdRepository(this.getRrdRepository(collectionName));
            return this.m_collectionHandler.collect(agent, collection, parameters);
        }
        catch (Exception e) {
            throw new CollectionException("Can't collect XML data because " + e.getMessage(), (Throwable)e);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.m_xmlCollectionDao.getConfig().buildRrdRepository(collectionName);
    }
}

