/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.protocols.sftp.Sftp3gppUrlConnection;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;
import org.opennms.protocols.xml.collector.Sftp3gppUtils;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class Sftp3gppXmlCollectionHandler
extends AbstractXmlCollectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Sftp3gppXmlCollectionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlCollectionSet collect(CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
        Object object;
        XmlCollectionSet collectionSet = new XmlCollectionSet();
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.setStatus(0);
        DateTime startTime = new DateTime();
        Sftp3gppUrlConnection connection = null;
        try {
            ResourcePath resourcePath = ResourcePath.get((String[])new String[]{"snmp", Integer.toString(agent.getNodeId())});
            for (XmlSource source : collection.getXmlSources()) {
                if (!source.getUrl().startsWith("sftp.3gpp")) {
                    throw new CollectionException("The 3GPP SFTP Collection Handler can only use the protocol sftp.3gpp");
                }
                String urlStr = this.parseUrl(source.getUrl(), agent, collection.getXmlRrd().getStep());
                Request request = this.parseRequest(source.getRequest(), agent, collection.getXmlRrd().getStep());
                URL url = UrlFactory.getUrl(urlStr, request);
                String lastFile = Sftp3gppUtils.getLastFilename(this.getResourceStorageDao(), this.getServiceName(), resourcePath, url.getPath());
                connection = (Sftp3gppUrlConnection)url.openConnection();
                if (lastFile == null) {
                    lastFile = connection.get3gppFileName();
                    LOG.debug("collect(single): retrieving file from {}{}{} from {}", new Object[]{url.getPath(), Character.valueOf(File.separatorChar), lastFile, agent.getHostAddress()});
                    Document doc = this.getXmlDocument(urlStr, request);
                    this.fillCollectionSet(agent, collectionSet, source, doc);
                    Sftp3gppUtils.setLastFilename(this.getResourceStorageDao(), this.getServiceName(), resourcePath, url.getPath(), lastFile);
                    Sftp3gppUtils.deleteFile(connection, lastFile);
                    continue;
                }
                connection.connect();
                List<String> files = connection.getFileList();
                long lastTs = connection.getTimeStampFromFile(lastFile);
                boolean collected = false;
                for (String fileName : files) {
                    if (connection.getTimeStampFromFile(fileName) <= lastTs) continue;
                    LOG.debug("collect(multiple): retrieving file {} from {}", (Object)fileName, (Object)agent.getHostAddress());
                    InputStream is = connection.getFile(fileName);
                    try {
                        Document doc = this.getXmlDocument(is, request);
                        IOUtils.closeQuietly((InputStream)is);
                        this.fillCollectionSet(agent, collectionSet, source, doc);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    Sftp3gppUtils.setLastFilename(this.getResourceStorageDao(), this.getServiceName(), resourcePath, url.getPath(), fileName);
                    Sftp3gppUtils.deleteFile(connection, fileName);
                    collected = true;
                }
                if (collected) continue;
                LOG.warn("collect: could not find any file after {} on {}", (Object)lastFile, (Object)agent);
            }
            collectionSet.setStatus(1);
            object = collectionSet;
        }
        catch (Exception e) {
            try {
                collectionSet.setStatus(2);
                throw new CollectionException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                String status = collectionSet.getStatus() == 1 ? "finished" : "failed";
                DateTime endTime = new DateTime();
                LOG.debug("collect: {} collection {}: duration: {} ms", new Object[]{status, collection.getName(), endTime.getMillis() - startTime.getMillis()});
                UrlFactory.disconnect(connection);
                throw throwable;
            }
        }
        String status = collectionSet.getStatus() == 1 ? "finished" : "failed";
        DateTime endTime = new DateTime();
        LOG.debug("collect: {} collection {}: duration: {} ms", new Object[]{status, collection.getName(), endTime.getMillis() - startTime.getMillis()});
        UrlFactory.disconnect(connection);
        return object;
    }

    @Override
    protected void fillCollectionSet(String urlString, Request request, CollectionAgent agent, XmlCollectionSet collectionSet, XmlSource source) throws Exception {
    }

    @Override
    protected void processXmlResource(XmlCollectionResource resource, AttributeGroupType attribGroupType) {
        Sftp3gppUtils.processXmlResource(resource, attribGroupType);
    }
}

