/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.json.collector;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.collector.XmlSingleInstanceCollectionResource;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonCollectionHandler
extends AbstractXmlCollectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJsonCollectionHandler.class);

    protected void fillCollectionSet(CollectionAgent agent, XmlCollectionSet collectionSet, XmlSource source, JSONObject json) throws ParseException {
        XmlSingleInstanceCollectionResource nodeResource = new XmlSingleInstanceCollectionResource(agent);
        JXPathContext context = JXPathContext.newContext((Object)json);
        for (XmlGroup group : source.getXmlGroups()) {
            LOG.debug("fillCollectionSet: getting resources for XML group {} using XPATH {}", (Object)group.getName(), (Object)group.getResourceXpath());
            Date timestamp = this.getTimeStamp(context, group);
            Iterator itr = context.iteratePointers(group.getResourceXpath());
            while (itr.hasNext()) {
                JXPathContext relativeContext = context.getRelativeContext((Pointer)itr.next());
                String resourceName = this.getResourceName(relativeContext, group);
                LOG.debug("fillCollectionSet: processing XML resource {} of type {}", (Object)resourceName, (Object)group.getResourceType());
                XmlCollectionResource collectionResource = group.getResourceType().equalsIgnoreCase("node") ? nodeResource : this.getCollectionResource(agent, resourceName, group.getResourceType(), timestamp);
                LOG.debug("fillCollectionSet: processing resource {}", (Object)collectionResource);
                AttributeGroupType attribGroupType = new AttributeGroupType(group.getName(), group.getIfType());
                for (XmlObject object : group.getXmlObjects()) {
                    try {
                        Object obj = relativeContext.getValue(object.getXpath());
                        if (obj == null) continue;
                        String value = obj.toString();
                        XmlCollectionAttributeType attribType = new XmlCollectionAttributeType(object, attribGroupType);
                        collectionResource.setAttributeValue(attribType, value);
                    }
                    catch (JXPathException ex) {
                        LOG.warn("Unable to get value for {}: {}", (Object)object.getXpath(), (Object)ex.getMessage());
                    }
                }
                this.processXmlResource(collectionResource, attribGroupType);
                collectionSet.getCollectionResources().add(collectionResource);
            }
        }
    }

    private String getResourceName(JXPathContext context, XmlGroup group) {
        if (group.hasMultipleResourceKey()) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : group.getXmlResourceKey().getKeyXpathList()) {
                LOG.debug("getResourceName: getting key for resource's name using {}", (Object)key);
                String keyName = (String)context.getValue(key);
                keys.add(keyName);
            }
            return StringUtils.join(keys, (String)"_");
        }
        if (group.getKeyXpath() == null) {
            return "node";
        }
        LOG.debug("getResourceName: getting key for resource's name using {}", (Object)group.getKeyXpath());
        return (String)context.getValue(group.getKeyXpath());
    }

    protected Date getTimeStamp(JXPathContext context, XmlGroup group) {
        if (group.getTimestampXpath() == null) {
            return null;
        }
        String pattern = group.getTimestampFormat() == null ? "yyyy-MM-dd HH:mm:ss" : group.getTimestampFormat();
        LOG.debug("getTimeStamp: retrieving custom timestamp to be used when updating RRDs using XPATH {} and pattern {}", (Object)group.getTimestampXpath(), (Object)pattern);
        Date date = null;
        String value = (String)context.getValue(group.getTimestampXpath());
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern);
            DateTime dateTime = dtf.parseDateTime(value);
            date = dateTime.toDate();
        }
        catch (Exception e) {
            LOG.warn("getTimeStamp: can't convert custom timestamp {} using pattern {}", (Object)value, (Object)pattern);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getJSONObject(String urlString, Request request) throws Exception {
        JSONObject jSONObject;
        InputStream is = null;
        URLConnection c = null;
        try {
            JSONObject jsonObject;
            URL url = UrlFactory.getUrl(urlString, request);
            c = url.openConnection();
            is = c.getInputStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)writer);
            jSONObject = jsonObject = JSONObject.fromObject((Object)writer.toString());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            UrlFactory.disconnect(c);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        UrlFactory.disconnect(c);
        return jSONObject;
    }
}

