/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersisterFactory;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy;
import org.opennms.protocols.xml.collector.MockDocumentBuilder;
import org.opennms.protocols.xml.collector.XmlCollector;
import org.opennms.protocols.xml.config.XmlRrd;
import org.opennms.protocols.xml.dao.XmlDataCollectionConfigDao;
import org.opennms.protocols.xml.dao.jaxb.XmlDataCollectionConfigDaoJaxb;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class NodeLevelDataOnMultipleNodesTest {
    @Rule
    public TemporaryFolder m_temporaryFolder = new TemporaryFolder();
    private EventProxy m_eventProxy;
    private XmlDataCollectionConfigDaoJaxb m_xmlCollectionDao;
    private XmlCollector m_collector;
    private RrdStrategy<?, ?> m_rrdStrategy;
    private FilesystemResourceStorageDao m_resourceStorageDao;
    private RrdPersisterFactory m_persisterFactory;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_rrdStrategy = this.getRrdStrategy();
        this.m_resourceStorageDao = new FilesystemResourceStorageDao();
        this.m_resourceStorageDao.setRrdDirectory(this.m_temporaryFolder.getRoot());
        this.m_temporaryFolder.newFolder(new String[]{"snmp"});
        this.m_persisterFactory = new RrdPersisterFactory();
        this.m_persisterFactory.setResourceStorageDao((ResourceStorageDao)this.m_resourceStorageDao);
        this.m_persisterFactory.setRrdStrategy(this.m_rrdStrategy);
        this.m_eventProxy = (EventProxy)EasyMock.createMock(EventProxy.class);
        this.m_xmlCollectionDao = new XmlDataCollectionConfigDaoJaxb();
        FileSystemResource resource = new FileSystemResource(this.getXmlConfigFileName());
        this.m_xmlCollectionDao.setConfigResource((Resource)resource);
        this.m_xmlCollectionDao.afterPropertiesSet();
        this.m_collector = new XmlCollector();
        this.m_collector.setXmlCollectionDao((XmlDataCollectionConfigDao)this.m_xmlCollectionDao);
        EasyMock.replay((Object[])new Object[]{this.m_eventProxy});
    }

    protected RrdStrategy<?, ?> getRrdStrategy() throws Exception {
        return new JRobinRrdStrategy();
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.m_eventProxy});
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testMultipleNodes() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "NodeLevel");
        parameters.put("handler-class", "org.opennms.protocols.xml.collector.MockDefaultXmlCollectionHandler");
        this.executeCollectorTest(1, "127.0.0.1", "src/test/resources/node-level.xml", parameters, 1);
        File file = new File(this.getSnmpRoot(), "1/node-level-stats.jrb");
        String[] dsnames = new String[]{"v1", "v2", "v3", "v4", "v5", "v6"};
        Double[] dsvalues = new Double[]{10.0, 11.0, 12.0, 13.0, 14.0, 15.0};
        this.validateJrb(file, dsnames, dsvalues);
        this.executeCollectorTest(2, "127.0.0.2", "src/test/resources/node-level-2.xml", parameters, 1);
        file = new File(this.getSnmpRoot(), "2/node-level-stats.jrb");
        dsnames = new String[]{"v1", "v2", "v3", "v4", "v5", "v6"};
        dsvalues = new Double[]{20.0, 21.0, 22.0, 23.0, 24.0, 25.0};
        this.validateJrb(file, dsnames, dsvalues);
        this.executeCollectorTest(3, "127.0.0.3", "src/test/resources/node-level-3.xml", parameters, 1);
        file = new File(this.getSnmpRoot(), "3/node-level-stats.jrb");
        dsnames = new String[]{"v1", "v2", "v3", "v4", "v5", "v6"};
        dsvalues = new Double[]{30.0, 31.0, 32.0, 33.0, 34.0, 35.0};
        this.validateJrb(file, dsnames, dsvalues);
    }

    protected String getRrdExtension() {
        return "jrb";
    }

    public XmlDataCollectionConfigDaoJaxb getConfigDao() {
        return this.m_xmlCollectionDao;
    }

    public String getXmlConfigFileName() {
        return "src/test/resources/node-level-datacollection-config.xml";
    }

    public void executeCollectorTest(int nodeId, String ipAddress, String xmlSampleFileName, Map<String, Object> parameters, int expectedFiles) throws Exception {
        MockDocumentBuilder.setXmlFileName(xmlSampleFileName);
        CollectionAgent collectionAgent = (CollectionAgent)EasyMock.createMock(CollectionAgent.class);
        EasyMock.expect((Object)collectionAgent.getNodeId()).andReturn((Object)nodeId).anyTimes();
        EasyMock.expect((Object)collectionAgent.getHostAddress()).andReturn((Object)ipAddress).anyTimes();
        EasyMock.expect((Object)collectionAgent.getStorageDir()).andReturn((Object)new File(Integer.toString(nodeId))).anyTimes();
        EasyMock.replay((Object[])new Object[]{collectionAgent});
        this.m_collector.initialize(collectionAgent, parameters);
        CollectionSet collectionSet = this.m_collector.collect(collectionAgent, this.m_eventProxy, parameters);
        this.m_collector.release(collectionAgent);
        collectionSet = this.m_collector.collect(collectionAgent, this.m_eventProxy, parameters);
        this.m_collector.release(collectionAgent);
        Assert.assertEquals((long)1L, (long)collectionSet.getStatus());
        ServiceParameters serviceParams = new ServiceParameters(new HashMap());
        Persister persister = this.m_persisterFactory.createGroupPersister(serviceParams, this.createRrdRepository((String)parameters.get("collection")), false, false);
        collectionSet.visit((CollectionSetVisitor)persister);
        Assert.assertEquals((long)expectedFiles, (long)FileUtils.listFiles((File)new File(this.getSnmpRoot(), Integer.toString(nodeId)), (String[])new String[]{this.getRrdExtension()}, (boolean)true).size());
        EasyMock.verify((Object[])new Object[]{collectionAgent});
    }

    public void validateJrb(File file, String[] dsnames, Double[] dsvalues) throws Exception {
        Assert.assertTrue((boolean)file.exists());
        RrdDb jrb = new RrdDb(file);
        Assert.assertEquals((long)dsnames.length, (long)jrb.getDsCount());
        for (int i = 0; i < dsnames.length; ++i) {
            Datasource ds = jrb.getDatasource(dsnames[i]);
            Assert.assertNotNull((Object)ds);
            Assert.assertEquals((Object)dsvalues[i], (Object)ds.getLastValue());
        }
    }

    private RrdRepository createRrdRepository(String collection) throws IOException {
        XmlRrd rrd = this.m_xmlCollectionDao.getDataCollectionByName(collection).getXmlRrd();
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(this.getSnmpRoot());
        repository.setHeartBeat(rrd.getStep() * 2);
        repository.setStep(rrd.getStep().intValue());
        repository.setRraList(rrd.getXmlRras());
        return repository;
    }

    public File getSnmpRoot() {
        return new File(this.m_temporaryFolder.getRoot(), "snmp");
    }
}

