/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.http.collector;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.protocols.xml.collector.AbstractXmlCollectionHandler;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.collector.XmlCollectionResource;
import org.opennms.protocols.xml.collector.XmlCollectionSet;
import org.opennms.protocols.xml.collector.XmlSingleInstanceCollectionResource;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCollectionHandler
extends AbstractXmlCollectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCollectionHandler.class);

    @Override
    protected void fillCollectionSet(String urlString, Request request, CollectionAgent agent, XmlCollectionSet collectionSet, XmlSource source) throws Exception {
        XmlSingleInstanceCollectionResource nodeResource = new XmlSingleInstanceCollectionResource(agent);
        Document doc = this.getJsoupDocument(urlString, request);
        for (XmlGroup group : source.getXmlGroups()) {
            LOG.debug("fillCollectionSet: getting resources for XML group {} using selector {}", (Object)group.getName(), (Object)group.getResourceXpath());
            Date timestamp = this.getTimeStamp(doc, group);
            Elements elements = doc.select(group.getResourceXpath());
            LOG.debug("fillCollectionSet: {} => {}", (Object)group.getResourceXpath(), (Object)elements);
            String resourceName = this.getResourceName(elements, group);
            LOG.debug("fillCollectionSet: processing XML resource {}", (Object)resourceName);
            XmlCollectionResource collectionResource = group.getResourceType().equalsIgnoreCase("node") ? nodeResource : this.getCollectionResource(agent, resourceName, group.getResourceType(), timestamp);
            LOG.debug("fillCollectionSet: processing resource {}", (Object)collectionResource);
            AttributeGroupType attribGroupType = new AttributeGroupType(group.getName(), group.getIfType());
            for (XmlObject object : group.getXmlObjects()) {
                Elements el = elements.select(object.getXpath());
                XmlCollectionAttributeType attribType = new XmlCollectionAttributeType(object, attribGroupType);
                collectionResource.setAttributeValue(attribType, el == null ? null : el.html());
            }
            this.processXmlResource(collectionResource, attribGroupType);
            collectionSet.getCollectionResources().add(collectionResource);
        }
    }

    @Override
    protected void processXmlResource(XmlCollectionResource collectionResource, AttributeGroupType attribGroupType) {
    }

    private String getResourceName(Elements elements, XmlGroup group) {
        if (group.hasMultipleResourceKey()) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : group.getXmlResourceKey().getKeyXpathList()) {
                LOG.debug("getResourceName: getting key for resource's name using selector {}", (Object)key);
                Elements el = elements.select(key);
                if (el == null) continue;
                keys.add(el.html());
            }
            return StringUtils.join(keys, (String)"_");
        }
        if (group.getKeyXpath() == null) {
            return "node";
        }
        LOG.debug("getResourceName: getting key for resource's name using selector {}", (Object)group.getKeyXpath());
        Elements el = elements.select(group.getKeyXpath());
        return el == null ? null : el.html();
    }

    protected Date getTimeStamp(Document doc, XmlGroup group) {
        if (group.getTimestampXpath() == null) {
            return null;
        }
        String pattern = group.getTimestampFormat() == null ? "yyyy-MM-dd HH:mm:ss" : group.getTimestampFormat();
        LOG.debug("getTimeStamp: retrieving custom timestamp to be used when updating RRDs using selector {} and pattern {}", (Object)group.getTimestampXpath(), (Object)pattern);
        Elements el = doc.select(group.getTimestampXpath());
        if (el == null) {
            return null;
        }
        String value = el.html();
        Date date = null;
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern);
            DateTime dateTime = dtf.parseDateTime(value);
            date = dateTime.toDate();
        }
        catch (Exception e) {
            LOG.warn("getTimeStamp: can't convert custom timetime {} using pattern {}", (Object)value, (Object)pattern);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getJsoupDocument(String urlString, Request request) throws Exception {
        Document document;
        InputStream is = null;
        URLConnection c = null;
        try {
            Document doc;
            URL url = UrlFactory.getUrl(urlString, request);
            c = url.openConnection();
            is = c.getInputStream();
            document = doc = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"/");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            UrlFactory.disconnect(c);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        UrlFactory.disconnect(c);
        return document;
    }
}

