/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.io.File;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.protocols.xml.collector.AbstractXmlCollectorTest;
import org.opennms.protocols.xml.collector.MockDocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlCollectorSolarisZonesTest
extends AbstractXmlCollectorTest {
    @Override
    public String getXmlConfigFileName() {
        return "src/test/resources/solaris-zones-datacollection-config.xml";
    }

    @Override
    public String getXmlSampleFileName() {
        return "src/test/resources/solaris-zones.xml";
    }

    @Test
    public void testXpath() throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        Document doc = MockDocumentBuilder.getXmlDocument();
        NodeList resourceList = (NodeList)xpath.evaluate("/zones/zone", doc, XPathConstants.NODESET);
        for (int j = 0; j < resourceList.getLength(); ++j) {
            Node resource = resourceList.item(j);
            Node resourceName = (Node)xpath.evaluate("@name", resource, XPathConstants.NODE);
            Assert.assertNotNull((Object)resourceName);
            String value = (String)xpath.evaluate("parameter[@key='nproc']/@value", resource, XPathConstants.STRING);
            Assert.assertNotNull((Object)Integer.valueOf(value));
        }
    }

    @Test
    public void testDefaultXmlCollector() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("collection", "Solaris");
        parameters.put("handler-class", "org.opennms.protocols.xml.collector.MockDefaultXmlCollectionHandler");
        this.executeCollectorTest(parameters, 3);
        Assert.assertTrue((boolean)new File("target/snmp/1/solarisZoneStats/global/solaris-zone-stats.jrb").exists());
        Assert.assertTrue((boolean)new File("target/snmp/1/solarisZoneStats/zone1/solaris-zone-stats.jrb").exists());
        Assert.assertTrue((boolean)new File("target/snmp/1/solarisZoneStats/zone2/solaris-zone-stats.jrb").exists());
        File file = new File("target/snmp/1/solarisZoneStats/global/solaris-zone-stats.jrb");
        String[] dsnames = new String[]{"nproc", "nlwp", "pr_size", "pr_rssize", "pctmem", "pctcpu"};
        Double[] dsvalues = new Double[]{245.0, 1455.0, 2646864.0, 1851072.0, 0.7, 0.24};
        this.validateJrb(file, dsnames, dsvalues);
    }
}

