/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.protocols.xml.collector.XmlCollectionAttribute;
import org.opennms.protocols.xml.collector.XmlCollectionAttributeType;
import org.opennms.protocols.xml.config.XmlObject;

public class XmlCollectionAttributeTest {
    @Test
    public void testNumericValuesWithUnits() {
        XmlObject object = new XmlObject("test", "gauge");
        AttributeGroupType group = new AttributeGroupType("xml-data", "all");
        XmlCollectionAttributeType type = new XmlCollectionAttributeType(object, group);
        XmlCollectionAttribute a = new XmlCollectionAttribute(null, type, "4.6");
        Assert.assertEquals((Object)"4.6", (Object)a.getNumericValue());
        Assert.assertEquals((Object)"4.6", (Object)a.getStringValue());
        a = new XmlCollectionAttribute(null, type, "4.6%");
        Assert.assertEquals((Object)"4.6", (Object)a.getNumericValue());
        Assert.assertEquals((Object)"4.6%", (Object)a.getStringValue());
        a = new XmlCollectionAttribute(null, type, "4.6Bps");
        Assert.assertEquals((Object)"4.6", (Object)a.getNumericValue());
        Assert.assertEquals((Object)"4.6Bps", (Object)a.getStringValue());
        a = new XmlCollectionAttribute(null, type, "4.6 bps");
        Assert.assertEquals((Object)"4.6", (Object)a.getNumericValue());
        Assert.assertEquals((Object)"4.6 bps", (Object)a.getStringValue());
        a = new XmlCollectionAttribute(null, type, "-42");
        Assert.assertEquals((Object)"-42.0", (Object)a.getNumericValue());
        Assert.assertEquals((Object)"-42", (Object)a.getStringValue());
        a = new XmlCollectionAttribute(null, type, "-32 celcius");
        Assert.assertEquals((Object)"-32.0", (Object)a.getNumericValue());
        Assert.assertEquals((Object)"-32 celcius", (Object)a.getStringValue());
        a = new XmlCollectionAttribute(null, type, "4.2E2");
        Assert.assertEquals((Object)"420.0", (Object)a.getNumericValue());
        Assert.assertEquals((Object)"4.2E2", (Object)a.getStringValue());
        a = new XmlCollectionAttribute(null, type, "-4e-2");
        Assert.assertEquals((Object)"-0.04", (Object)a.getNumericValue());
        Assert.assertEquals((Object)"-4e-2", (Object)a.getStringValue());
    }
}

